package cn.easyutil.easyapi.configuration.filter;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.RequestExtra;
import cn.easyutil.easyapi.logic.creator.MethodParam;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * 控制器解析
 */
@Component
@ConfigurationProperties(prefix = "easyapi.filter.request")
public class EasyApiRequestReaderFilter {

    //参数校验
    private List<Class<List<HandlerChain<RequestExtra,List<String>>>>> condition = new ArrayList<>();

    //字段说明
    private List<Class<List<HandlerChain<RequestExtra,String>>>> description = new ArrayList<>();

    //忽略
    private List<Class<List<HandlerChain<RequestExtra,Boolean>>>> ignore = new ArrayList<>();

    //mock模板
    private List<Class<List<HandlerChain<RequestExtra,String>>>> mockTemplate = new ArrayList<>();

    //字段名称
    private List<Class<List<HandlerChain<RequestExtra,String>>>> name = new ArrayList<>();

    //字段实际java类型，如果是对象，此处为对象的多个属性
    private List<Class<List<HandlerChain<RequestExtra,List<MethodParam>>>>> param = new ArrayList<>();

    //是否必填
    private List<Class<List<HandlerChain<RequestExtra,Boolean>>>> required = new ArrayList<>();

    //是否显示
    private List<Class<List<HandlerChain<RequestExtra,Boolean>>>> show = new ArrayList<>();

    //字段类型
    private List<Class<List<HandlerChain<RequestExtra, Type>>>> type = new ArrayList<>();


    public List<Class<List<HandlerChain<RequestExtra, List<String>>>>> getCondition() {
        return condition;
    }

    public void setCondition(List<Class<List<HandlerChain<RequestExtra, List<String>>>>> condition) {
        this.condition = condition;
    }

    public List<Class<List<HandlerChain<RequestExtra, String>>>> getDescription() {
        return description;
    }

    public void setDescription(List<Class<List<HandlerChain<RequestExtra, String>>>> description) {
        this.description = description;
    }

    public List<Class<List<HandlerChain<RequestExtra, Boolean>>>> getIgnore() {
        return ignore;
    }

    public void setIgnore(List<Class<List<HandlerChain<RequestExtra, Boolean>>>> ignore) {
        this.ignore = ignore;
    }

    public List<Class<List<HandlerChain<RequestExtra, String>>>> getMockTemplate() {
        return mockTemplate;
    }

    public void setMockTemplate(List<Class<List<HandlerChain<RequestExtra, String>>>> mockTemplate) {
        this.mockTemplate = mockTemplate;
    }

    public List<Class<List<HandlerChain<RequestExtra, String>>>> getName() {
        return name;
    }

    public void setName(List<Class<List<HandlerChain<RequestExtra, String>>>> name) {
        this.name = name;
    }

    public List<Class<List<HandlerChain<RequestExtra, List<MethodParam>>>>> getParam() {
        return param;
    }

    public void setParam(List<Class<List<HandlerChain<RequestExtra, List<MethodParam>>>>> param) {
        this.param = param;
    }

    public List<Class<List<HandlerChain<RequestExtra, Boolean>>>> getRequired() {
        return required;
    }

    public void setRequired(List<Class<List<HandlerChain<RequestExtra, Boolean>>>> required) {
        this.required = required;
    }

    public List<Class<List<HandlerChain<RequestExtra, Boolean>>>> getShow() {
        return show;
    }

    public void setShow(List<Class<List<HandlerChain<RequestExtra, Boolean>>>> show) {
        this.show = show;
    }

    public List<Class<List<HandlerChain<RequestExtra, Type>>>> getType() {
        return type;
    }

    public void setType(List<Class<List<HandlerChain<RequestExtra, Type>>>> type) {
        this.type = type;
    }
}
