package cn.easyutil.easyapi.configuration.filter;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ControllerExtra;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 控制器解析
 */
@Component
@ConfigurationProperties(prefix = "easyapi.filter.controller")
public class EasyApiControllerReaderFilter {

    //作者
    private List<Class<List<HandlerChain<ControllerExtra,String>>>> author = new ArrayList<>();

    //控制器说明
    private List<Class<List<HandlerChain<ControllerExtra,String>>>> description = new ArrayList<>();

    //忽略
    private List<Class<List<HandlerChain<ControllerExtra,Boolean>>>> ignore = new ArrayList<>();

    //父路径提取
    private List<Class<List<HandlerChain<ControllerExtra,String>>>> path = new ArrayList<>();

    //扫描控制器
    private List<Class<List<HandlerChain<ControllerExtra,List<Class>>>>> scan = new ArrayList<>();

    //是否显示
    private List<Class<List<HandlerChain<ControllerExtra,Boolean>>>> show = new ArrayList<>();

    //控制器名称
    private List<Class<List<HandlerChain<ControllerExtra,String>>>> name = new ArrayList<>();


    public List<Class<List<HandlerChain<ControllerExtra, String>>>> getAuthor() {
        return author;
    }

    public void setAuthor(List<Class<List<HandlerChain<ControllerExtra, String>>>> author) {
        this.author = author;
    }

    public List<Class<List<HandlerChain<ControllerExtra, String>>>> getDescription() {
        return description;
    }

    public void setDescription(List<Class<List<HandlerChain<ControllerExtra, String>>>> description) {
        this.description = description;
    }

    public List<Class<List<HandlerChain<ControllerExtra, Boolean>>>> getIgnore() {
        return ignore;
    }

    public void setIgnore(List<Class<List<HandlerChain<ControllerExtra, Boolean>>>> ignore) {
        this.ignore = ignore;
    }

    public List<Class<List<HandlerChain<ControllerExtra, String>>>> getPath() {
        return path;
    }

    public void setPath(List<Class<List<HandlerChain<ControllerExtra, String>>>> path) {
        this.path = path;
    }

    public List<Class<List<HandlerChain<ControllerExtra, List<Class>>>>> getScan() {
        return scan;
    }

    public void setScan(List<Class<List<HandlerChain<ControllerExtra, List<Class>>>>> scan) {
        this.scan = scan;
    }

    public List<Class<List<HandlerChain<ControllerExtra, Boolean>>>> getShow() {
        return show;
    }

    public void setShow(List<Class<List<HandlerChain<ControllerExtra, Boolean>>>> show) {
        this.show = show;
    }

    public List<Class<List<HandlerChain<ControllerExtra, String>>>> getName() {
        return name;
    }

    public void setName(List<Class<List<HandlerChain<ControllerExtra, String>>>> name) {
        this.name = name;
    }
}
