package cn.easyutil.easyapi.configuration.filter;

import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;
import cn.easyutil.easyapi.logic.creator.FieldParam;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * 参数bean解析过滤
 */
@Component
@ConfigurationProperties(prefix = "easyapi.filter.bean")
public class EasyApiBeanReaderFilter {

    //参数校验
    private List<Class<HandlerChain<ModelFieldExtra, List<String>>>> condition = new ArrayList<>();

    //字段说明
    private List<Class<HandlerChain<ModelFieldExtra, String>>> description = new ArrayList<>();

    //忽略
    private List<Class<HandlerChain<ModelFieldExtra, Boolean>>> ignore = new ArrayList<>();

    //字段类型
    private List<Class<HandlerChain<ModelFieldExtra, JavaType>>> javaType = new ArrayList<>();

    //mock模板
    private List<Class<HandlerChain<ModelFieldExtra, String>>> mockTemplate = new ArrayList<>();

    //字段名称
    private List<Class<HandlerChain<ModelFieldExtra, String>>> name = new ArrayList<>();

    //字段实际java类型，如果是对象，此处为对象的多个属性
    private List<Class<HandlerChain<ModelFieldExtra, List<FieldParam>>>> param = new ArrayList<>();

    //更新策略
    private List<Class<HandlerChain<ModelFieldExtra, RenewType>>> renewType = new ArrayList<>();

    //是否必填
    private List<Class<HandlerChain<ModelFieldExtra, Boolean>>> required = new ArrayList<>();

    //是否显示
    private List<Class<HandlerChain<ModelFieldExtra, Boolean>>> show = new ArrayList<>();

    //字段对应的type
    private List<Class<HandlerChain<ModelFieldExtra, Type>>> type = new ArrayList<>();

    public List<Class<HandlerChain<ModelFieldExtra, List<String>>>> getCondition() {
        return condition;
    }

    public void setCondition(List<Class<HandlerChain<ModelFieldExtra, List<String>>>> condition) {
        this.condition = condition;
    }

    public List<Class<HandlerChain<ModelFieldExtra, String>>> getDescription() {
        return description;
    }

    public void setDescription(List<Class<HandlerChain<ModelFieldExtra, String>>> description) {
        this.description = description;
    }

    public List<Class<HandlerChain<ModelFieldExtra, Boolean>>> getIgnore() {
        return ignore;
    }

    public void setIgnore(List<Class<HandlerChain<ModelFieldExtra, Boolean>>> ignore) {
        this.ignore = ignore;
    }

    public List<Class<HandlerChain<ModelFieldExtra, JavaType>>> getJavaType() {
        return javaType;
    }

    public void setJavaType(List<Class<HandlerChain<ModelFieldExtra, JavaType>>> javaType) {
        this.javaType = javaType;
    }

    public List<Class<HandlerChain<ModelFieldExtra, String>>> getMockTemplate() {
        return mockTemplate;
    }

    public void setMockTemplate(List<Class<HandlerChain<ModelFieldExtra, String>>> mockTemplate) {
        this.mockTemplate = mockTemplate;
    }

    public List<Class<HandlerChain<ModelFieldExtra, String>>> getName() {
        return name;
    }

    public void setName(List<Class<HandlerChain<ModelFieldExtra, String>>> name) {
        this.name = name;
    }

    public List<Class<HandlerChain<ModelFieldExtra, List<FieldParam>>>> getParam() {
        return param;
    }

    public void setParam(List<Class<HandlerChain<ModelFieldExtra, List<FieldParam>>>> param) {
        this.param = param;
    }

    public List<Class<HandlerChain<ModelFieldExtra, RenewType>>> getRenewType() {
        return renewType;
    }

    public void setRenewType(List<Class<HandlerChain<ModelFieldExtra, RenewType>>> renewType) {
        this.renewType = renewType;
    }

    public List<Class<HandlerChain<ModelFieldExtra, Boolean>>> getRequired() {
        return required;
    }

    public void setRequired(List<Class<HandlerChain<ModelFieldExtra, Boolean>>> required) {
        this.required = required;
    }

    public List<Class<HandlerChain<ModelFieldExtra, Boolean>>> getShow() {
        return show;
    }

    public void setShow(List<Class<HandlerChain<ModelFieldExtra, Boolean>>> show) {
        this.show = show;
    }

    public List<Class<HandlerChain<ModelFieldExtra, Type>>> getType() {
        return type;
    }

    public void setType(List<Class<HandlerChain<ModelFieldExtra, Type>>> type) {
        this.type = type;
    }
}
