package cn.easyutil.easyapi.configuration;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;

@Component
@ConfigurationProperties(prefix = "easyapi.datasource")
public class EasyApiDataConfiguration {

    /** 连接地址*/
    private String url;

    /** 连接用户名*/
    private String userName;

    /** 连接密码*/
    private String password;

    /** 驱动类*/
    private String driverClassName = "org.h2.Driver";

    /** h2数据文件存放地址及名称*/
    private String dbFilePath = "./doc";

    /** 连接池,一旦存在连接池，以上配置将失效*/
    private DataSource dataSource;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriverClassName() {
        return driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public DataSource getDataSource() {
        return dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDbFilePath() {
        return dbFilePath;
    }

    public void setDbFilePath(String dbFilePath) {
        this.dbFilePath = dbFilePath;
    }
}
