/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.util;

import cn.easyutil.easyapi.interview.JacksonBigLongTypeSerializer;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static Map<String, Object> jsonToMap(String json) {
        Map map = (Map)JSONObject.parse((String)json);
        return map;
    }

    public static Map<String, Object> beanToMap(Object obj) {
        return JsonUtil.jsonToMap(JsonUtil.beanToJson(obj));
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> beanClass) {
        return JsonUtil.jsonToBean(JsonUtil.beanToJson(map), beanClass);
    }

    public static String beanToJson(Object obj) {
        return JSONObject.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public static String toJackson(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            return JsonUtil.beanToJson(obj);
        }
    }

    public static <T> T parse(Object obj, Class<T> clazz) {
        return JsonUtil.jsonToBean(JsonUtil.beanToJson(obj), clazz);
    }

    public static <T> T jsonToBean(String jsonStr, Class<T> beanClass) {
        return (T)JSONObject.parseObject((String)jsonStr, beanClass);
    }

    public static <T> List<T> jsonToList(String jsonStr, Class<T> beanClass) {
        return JSONObject.parseArray((String)jsonStr, beanClass);
    }

    public static JSONObject JSONObject() {
        return new JSONObject();
    }

    public static JSONArray JSONArray() {
        return new JSONArray();
    }

    public static boolean isJson(String json) {
        try {
            JSONObject.parse((String)json);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        JavaTimeModule simpleModule = new JavaTimeModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)JacksonBigLongTypeSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)JacksonBigLongTypeSerializer.instance);
        objectMapper.registerModule((Module)simpleModule);
    }
}

