/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.condition;

import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.logic.condition.ConditionResult;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConditionUtil {
    public static ConditionResult alike(Map<String, DocParamEntity> params, String checkVal) {
        if (checkVal == null) {
            if (params.size() == 0) {
                return null;
            }
            ConditionResult result = new ConditionResult();
            result.setName(params.keySet().iterator().next());
            result.setDescription("\u7f3a\u5c11\u53c2\u6570");
            result.setWith("\u63a5\u53e3\u6587\u6863\u5b9a\u4e49\u672a\u627e\u5230\u8be5\u53c2\u6570");
            return result;
        }
        if (params.isEmpty()) {
            ConditionResult result = new ConditionResult();
            result.setDescription("\u672a\u77e5\u53c2\u6570");
            result.setWith("\u63a5\u53e3\u6587\u6863\u5b9a\u4e49\u4e3a\u65e0\u53c2");
            return result;
        }
        try {
            JSONObject obj = JSONObject.parseObject((String)checkVal);
            return ConditionUtil.checkObject(params, obj);
        }
        catch (JSONException e) {
            try {
                JSONArray array = JSONObject.parseArray((String)checkVal);
                return ConditionUtil.checkArray(params, array);
            }
            catch (JSONException e1) {
                return ConditionUtil.checkConst(params, checkVal);
            }
        }
    }

    private static ConditionResult checkArray(Map<String, DocParamEntity> params, JSONArray array) {
        List<DocParamEntity> ch = params.entrySet().iterator().next().getValue().getChildren();
        if (ch == null || !Collection.class.isAssignableFrom(ch.getClass())) {
            return null;
        }
        if (((Collection)ch).size() == 0) {
            return null;
        }
        if (!params.containsKey("_null")) {
            ConditionResult result = new ConditionResult();
            result.setName(params.keySet().iterator().next());
            result.setDescription("\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d");
            result.setWith("\u63a5\u53e3\u6587\u6863\u5b9a\u4e49\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d");
            return result;
        }
        DocParamEntity value = params.entrySet().iterator().next().getValue();
        if (array.isEmpty() && value.getRequired() == 0) {
            return null;
        }
        DocParamEntity entity = params.entrySet().iterator().next().getValue();
        JavaType javaType = JavaType.getType(entity.getJavaType());
        if (javaType != JavaType.ArrayObject && javaType != JavaType.Array) {
            ConditionResult result = new ConditionResult();
            result.setName(entity.getName());
            result.setDescription("\u53c2\u6570\u975e\u6570\u7ec4\u7c7b\u578b");
            result.setWith("\u63a5\u53e3\u6587\u6863\u5b9a\u4e49\u975e\u6570\u7ec4\u7c7b\u578b");
            return result;
        }
        Object obj = array.get(0);
        Map children = (Map)((Object)entity.getChildren());
        return ConditionUtil.alike(children, JsonUtil.beanToJson(obj));
    }

    private static ConditionResult checkObject(Map<String, DocParamEntity> params, JSONObject object) {
        if (params.containsKey("_null")) {
            ConditionResult result = new ConditionResult();
            result.setName(params.keySet().iterator().next());
            result.setDescription("\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d");
            result.setWith("\u63a5\u53e3\u6587\u6863\u5b9a\u4e49\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d");
            return result;
        }
        for (Map.Entry<String, DocParamEntity> next : params.entrySet()) {
            ConditionResult alike;
            String key = next.getKey();
            DocParamEntity value = JsonUtil.jsonToBean(JsonUtil.beanToJson(next.getValue()), DocParamEntity.class);
            Object checkVal = object.get((Object)key);
            if (checkVal == null) {
                if (value.getRequired() == 0) continue;
                ConditionResult result = new ConditionResult();
                result.setName(key);
                result.setDescription("\u7f3a\u5c11\u53c2\u6570");
                result.setWith("\u63a5\u53e3\u6587\u6863\u5b9a\u4e49\u672a\u627e\u5230\u8be5\u53c2\u6570");
                return result;
            }
            JavaType javaType = JavaType.getType(value.getJavaType());
            if (javaType == JavaType.ArrayObject || javaType == JavaType.Array) {
                Hashtable<String, DocParamEntity> entity = new Hashtable<String, DocParamEntity>();
                entity.put("_null", value);
                alike = ConditionUtil.alike(entity, JsonUtil.beanToJson(checkVal));
                if (alike == null) continue;
                return alike;
            }
            if (javaType == JavaType.Object) {
                Map children = (Map)((Object)value.getChildren());
                alike = ConditionUtil.alike(children, JsonUtil.beanToJson(checkVal));
                if (alike == null) continue;
                return alike;
            }
            if (!javaType.alikeClass(checkVal.getClass())) {
                ConditionResult result = new ConditionResult();
                result.setName(key);
                result.setDescription("\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d");
                result.setWith("\u63a5\u53e3\u6587\u6863\u5b9a\u4e49\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d");
                return result;
            }
            String conditionTemplate = value.getConditionTemplate();
            if (StringUtil.isEmpty(conditionTemplate)) continue;
            List list = Stream.of(conditionTemplate.split(",")).filter(s -> !StringUtil.isEmpty(s)).collect(Collectors.toList());
        }
        return null;
    }

    private static ConditionResult checkConst(Map<String, DocParamEntity> params, Object obj) {
        DocParamEntity entity = params.entrySet().iterator().next().getValue();
        if (!params.containsKey("_null")) {
            if (entity.getRequired() == 0) {
                return null;
            }
            ConditionResult result = new ConditionResult();
            result.setName(params.keySet().iterator().next());
            result.setDescription("\u7f3a\u5c11\u53c2\u6570");
            result.setWith("\u63a5\u53e3\u6587\u6863\u5b9a\u4e49\u672a\u627e\u5230\u8be5\u53c2\u6570");
            return result;
        }
        JavaType javaType = JavaType.getType(entity.getJavaType());
        if (javaType.alikeClass(obj.getClass())) {
            return null;
        }
        ConditionResult result = new ConditionResult();
        result.setName(entity.getName());
        result.setDescription("\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d");
        result.setWith("\u63a5\u53e3\u6587\u6863\u5b9a\u4e49\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d");
        return result;
    }
}

