/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBArticleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHeaderEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHostEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleOutPackageEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleScriptEntity;
import cn.easyutil.easyapi.entity.db.doc.DBMouduleEnvEntity;
import cn.easyutil.easyapi.handler.operator.provide.MockReaderProvider;
import cn.easyutil.easyapi.interview.dto.GetOutPackagesDto;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.dto.IdListDto;
import cn.easyutil.easyapi.interview.dto.SearchDto;
import cn.easyutil.easyapi.interview.dto.SelectInterfacesDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.vo.FindControllerAndInterfaceVo;
import cn.easyutil.easyapi.interview.vo.InterfaceInfoVo;
import cn.easyutil.easyapi.logic.condition.MockProcess2;
import cn.easyutil.easyapi.mybatis.service.ArticleService;
import cn.easyutil.easyapi.mybatis.service.ControllerService;
import cn.easyutil.easyapi.mybatis.service.EnvService;
import cn.easyutil.easyapi.mybatis.service.HeaderService;
import cn.easyutil.easyapi.mybatis.service.HostService;
import cn.easyutil.easyapi.mybatis.service.InterfaceParamService;
import cn.easyutil.easyapi.mybatis.service.InterfaceService;
import cn.easyutil.easyapi.mybatis.service.OutPackageService;
import cn.easyutil.easyapi.mybatis.service.ProjectService;
import cn.easyutil.easyapi.mybatis.service.ScriptService;
import cn.easyutil.easyapi.mybatis.service.UserService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiSimpleApidocController"})
@RequestMapping(value={"/easyapi/doc/simple"})
public class SimpleApidocController {
    private final ControllerService controllerService = new ControllerService();
    private final InterfaceService interfaceService = new InterfaceService();
    private final InterfaceParamService interfaceParamService = new InterfaceParamService();
    private final HostService hostService = new HostService();
    private final EnvService envService = new EnvService();
    private final HeaderService headerService = new HeaderService();
    private final ScriptService scriptService = new ScriptService();
    private final ArticleService articleService = new ArticleService();
    private final OutPackageService outPackageService = new OutPackageService();
    private final ProjectService projectService = new ProjectService();
    private final UserService userService = new UserService();

    @ApidocComment(value="\u83b7\u53d6\u63a5\u53e3\u63a7\u5236\u5668\u5217\u8868")
    @PostMapping(value={"/getControllers"})
    @AccessAuth(code=1000)
    public List<FindControllerAndInterfaceVo> getControllers(@RequestBody(required=false) SearchDto dto) {
        if (dto == null) {
            dto = new SearchDto();
        }
        Map<Object, Object> controllerAndInterfaceMap = new HashMap();
        List list = this.controllerService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DBModuleControllerEntity.class).select(new SFunction[]{BaseDbEntity::getId}).eq(DBModuleControllerEntity::getShow, (Object)1)).eq(BaseDbEntity::getProjectId, (Object)dto.getId())).like(!StringUtil.isEmpty(dto.getSearch()), DBModuleControllerEntity::getSearchTags, (Object)dto.getSearch()));
        if (list != null) {
            controllerAndInterfaceMap = list.stream().collect(Collectors.toMap(BaseDbEntity::getId, c -> new ArrayList()));
        }
        ArrayList<Object> inList = this.interfaceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DBModuleInterfaceEntity.class).select(new SFunction[]{BaseDbEntity::getId, DBModuleInterfaceEntity::getControllerId}).eq(DBModuleInterfaceEntity::getShowType, (Object)1)).eq(BaseDbEntity::getProjectId, (Object)dto.getId())).like(!StringUtil.isEmpty(dto.getSearch()), DBModuleInterfaceEntity::getSearchTags, (Object)dto.getSearch()));
        ArrayList customList = this.interfaceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DBModuleInterfaceEntity.class).select(new SFunction[]{BaseDbEntity::getId, DBModuleInterfaceEntity::getControllerId}).eq(DBModuleInterfaceEntity::getShowType, (Object)1)).eq(BaseDbEntity::getProjectId, (Object)dto.getId())).like(!StringUtil.isEmpty(dto.getSearch()), DBModuleInterfaceEntity::getCustomTags, (Object)dto.getSearch()));
        HashMap inMap = new HashMap();
        if (inList == null) {
            inList = new ArrayList();
        }
        if (customList == null) {
            customList = new ArrayList();
        }
        inList.addAll(customList);
        inList.forEach(item -> inMap.put(item.getId(), item));
        inList = new ArrayList(inMap.values());
        for (DBModuleInterfaceEntity dBModuleInterfaceEntity : inList) {
            Long inId = dBModuleInterfaceEntity.getId();
            Long controllerId = dBModuleInterfaceEntity.getControllerId();
            controllerAndInterfaceMap.computeIfAbsent(controllerId, k -> new ArrayList());
            ((List)controllerAndInterfaceMap.get(controllerId)).add(inId);
        }
        if (controllerAndInterfaceMap.isEmpty()) {
            return null;
        }
        ArrayList<FindControllerAndInterfaceVo> vos = new ArrayList<FindControllerAndInterfaceVo>();
        List list2 = this.controllerService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DBModuleControllerEntity.class).in(BaseDbEntity::getId, controllerAndInterfaceMap.keySet())).orderByAsc(DBModuleControllerEntity::getSort)).orderByAsc(DBModuleControllerEntity::getPinyin));
        for (DBModuleControllerEntity controller : list2) {
            FindControllerAndInterfaceVo vo = new FindControllerAndInterfaceVo();
            BeanUtils.copyProperties((Object)controller, (Object)vo);
            List inIds = (List)controllerAndInterfaceMap.get(controller.getId());
            if (inIds.isEmpty()) {
                vos.add(vo);
                continue;
            }
            List children = this.interfaceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DBModuleInterfaceEntity.class).in(BaseDbEntity::getId, (Collection)inIds)).orderByAsc(DBModuleInterfaceEntity::getSort)).orderByAsc(DBModuleInterfaceEntity::getPinyin));
            vo.setChildren(Optional.ofNullable(children).orElse(Collections.emptyList()));
            vos.add(vo);
        }
        return vos;
    }

    @ApidocComment(value="\u4fee\u6539\u63a7\u5236\u5668\u4fe1\u606f")
    @PostMapping(value={"/updateControllerInfo"})
    @AccessAuth(code=1000)
    public void updateControllerInfo(@RequestBody DBModuleControllerEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "\u63a7\u5236\u5668id\u4e0d\u80fd\u4e3a\u7a7a");
        this.controllerService.updateById(entity);
        DBModuleControllerEntity query = (DBModuleControllerEntity)this.controllerService.getById(entity.getId());
        query.setSearchTags(DBModuleControllerEntity.buildSearchTag(query));
        this.controllerService.updateById(query);
    }

    @ApidocComment(value="\u5220\u9664\u63a7\u5236\u5668\u4fe1\u606f")
    @PostMapping(value={"/delController"})
    @AccessAuth(code=1000)
    public void delController(@RequestBody IdDto dto) {
        this.controllerService.removeById(dto.getId());
    }

    @ApidocComment(value="\u67e5\u8be2\u63a5\u53e3\u5217\u8868")
    @PostMapping(value={"/selectInterfaces"})
    @AccessAuth(code=1000)
    public List<DBModuleInterfaceEntity> selectInterfaces(@RequestBody(required=false) SelectInterfacesDto dto) {
        DBModuleInterfaceEntity entity = new DBModuleInterfaceEntity();
        entity.setModuleId(CurrentSession.getCurrentModuleId());
        return this.interfaceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)entity).like(!StringUtil.isEmpty(dto.getSearch()), DBModuleInterfaceEntity::getSearchTags, (Object)dto.getSearch())).eq(dto.getControllerId() != null, DBModuleInterfaceEntity::getControllerId, (Object)dto.getControllerId())).orderByAsc(DBModuleInterfaceEntity::getSort)).orderByAsc(DBModuleInterfaceEntity::getPinyin));
    }

    @ApidocComment(value="\u4fee\u6539\u63a5\u53e3\u4fe1\u606f")
    @PostMapping(value={"/updateInterfaces"})
    @AccessAuth(code=1000)
    public void updateInterfaces(@RequestBody InterfaceInfoVo vo) {
        if (vo.getInfo() != null) {
            AssertUtil.isNull((Object)vo.getInfo().getId(), "\u63a5\u53e3id\u4e0d\u80fd\u4e3a\u7a7a");
            this.interfaceService.updateById(vo.getInfo());
            DBModuleInterfaceEntity query = (DBModuleInterfaceEntity)this.interfaceService.getById(vo.getInfo().getId());
            query.setSearchTags(DBModuleInterfaceEntity.buildSearchTag(query));
            this.interfaceService.updateById(query);
        }
        if (vo.getParams() != null) {
            AssertUtil.isNull((Object)vo.getParams().getId(), "\u63a5\u53e3\u8be6\u60c5id\u4e0d\u80fd\u4e3a\u7a7a");
            DBInterfaceParamEntity entity = vo.getParams();
            entity.setInterfaceId(null);
            this.interfaceParamService.updateById(entity);
        }
    }

    @ApidocComment(value="\u6839\u636e\u63a5\u53e3id\u83b7\u53d6\u63a5\u53e3\u8be6\u60c5\u4fe1\u606f")
    @PostMapping(value={"/interfaceInfo"})
    @AccessAuth(code=1000)
    public InterfaceInfoVo interfaceInfo(@RequestBody IdDto dto) {
        Object mock;
        List<DocParamEntity> mockParams;
        DBModuleInterfaceEntity info = (DBModuleInterfaceEntity)this.interfaceService.getById(dto.getId());
        AssertUtil.isNull((Object)info, "\u63a5\u53e3\u4e0d\u5b58\u5728");
        DBInterfaceParamEntity query = new DBInterfaceParamEntity();
        query.setInterfaceId(info.getId());
        DBInterfaceParamEntity params = (DBInterfaceParamEntity)this.interfaceParamService.getOne((Wrapper)Wrappers.lambdaQuery((Object)query), false);
        String requestParamJson = params.getRequestParamJson();
        String responseParamJson = params.getResponseParamJson();
        MockReaderProvider operator = ProjectContext.mockTemplateOperator;
        MockProcess2 mocker = MockProcess2.with(operator);
        mocker.setMockArraySize(ProjectContext.allConfiguration.getConfiguration().getMockArraySize());
        if (!StringUtil.isEmpty(requestParamJson)) {
            mockParams = JsonUtil.jsonToList(requestParamJson, DocParamEntity.class);
            mock = mocker.mockByApiParams(mockParams);
            params.setRequestMock(JsonUtil.beanToJson(mock));
            params.setRequestParamJson(JsonUtil.beanToJson(mockParams));
        }
        if (!StringUtil.isEmpty(responseParamJson)) {
            mockParams = JsonUtil.jsonToList(responseParamJson, DocParamEntity.class);
            mock = mocker.mockByApiParams(mockParams);
            params.setResponseMock(JsonUtil.beanToJson(mock));
            params.setResponseParamJson(JsonUtil.beanToJson(mockParams));
        }
        InterfaceInfoVo vo = new InterfaceInfoVo();
        vo.setInfo(info);
        vo.setParams(params);
        return vo;
    }

    @ApidocComment(value="\u5220\u9664\u63a5\u53e3\u4fe1\u606f")
    @PostMapping(value={"/delInterfaces"})
    @AccessAuth(code=1000)
    public void delInterfaces(@RequestBody IdDto dto) {
        this.interfaceService.removeById(dto.getId());
    }

    @ApidocComment(value="\u83b7\u53d6\u811a\u672c\u5217\u8868")
    @PostMapping(value={"/getScripts"})
    @AccessAuth(code=1000)
    public List<DBModuleScriptEntity> getScripts(@RequestBody DBModuleScriptEntity query) {
        Long userId = CurrentSession.getCurrentUser().getId();
        List self = this.scriptService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DBModuleScriptEntity.class).eq(DBModuleScriptEntity::getUserId, (Object)userId)).eq(query.getLocation() != null, DBModuleScriptEntity::getLocation, (Object)query.getLocation())).orderByAsc(DBModuleScriptEntity::getSort));
        DBModuleScriptEntity queryGlobal = new DBModuleScriptEntity();
        queryGlobal.setLocation(query.getLocation());
        queryGlobal.setType(1);
        List global = this.scriptService.list((Wrapper)Wrappers.lambdaQuery((Object)queryGlobal));
        return this.mergin(global, self);
    }

    @ApidocComment(value="\u6dfb\u52a0\u5168\u5c40\u811a\u672c")
    @PostMapping(value={"/addScript"})
    @AccessAuth(code=1000)
    public void addScript(@RequestBody DBModuleScriptEntity entity) {
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        Long userId = CurrentSession.getCurrentUser().getId();
        entity.setModuleId(currentModuleId);
        entity.setUserId(userId);
        this.scriptService.save(entity);
    }

    @ApidocComment(value="\u4fee\u6539\u5168\u5c40\u811a\u672c")
    @PostMapping(value={"/updateScript"})
    @AccessAuth(code=1000)
    public void updateScript(@RequestBody DBModuleScriptEntity entity) {
        this.scriptService.updateById(entity);
    }

    @ApidocComment(value="\u5220\u9664\u5168\u5c40\u811a\u672c")
    @PostMapping(value={"/delScript"})
    @AccessAuth(code=1000)
    public void delScript(@RequestBody IdDto dto) {
        this.scriptService.removeById(dto.getId());
    }

    @ApidocComment(value="\u83b7\u53d6\u6587\u7ae0\u5217\u8868")
    @PostMapping(value={"/getArticles"})
    @AccessAuth(code=1000)
    public List<DBArticleEntity> getArticles() {
        return this.articleService.list();
    }

    @ApidocComment(value="\u83b7\u53d6\u4e0a\u6b21\u6253\u5f00\u7684\u63a5\u53e3\u96c6\u5408")
    @PostMapping(value={"/getLastOpendInterfaces"})
    @AccessAuth(code=1000)
    public List<DBModuleInterfaceEntity> getLastOpendInterfaces(@RequestBody IdDto dto) {
        String lastOpendInterfaceIds = CurrentSession.getCurrentUser().getLastOpendInterfaceIds();
        if (StringUtil.isEmpty(lastOpendInterfaceIds)) {
            return null;
        }
        JSONObject map = JSONObject.parseObject((String)lastOpendInterfaceIds);
        if (!map.containsKey((Object)dto.getId().toString())) {
            return null;
        }
        JSONArray ids = map.getJSONArray(dto.getId().toString());
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        List interfaces = this.interfaceService.list((Wrapper)Wrappers.lambdaQuery(DBModuleInterfaceEntity.class).in(BaseDbEntity::getId, (Collection)ids));
        ArrayList<DBModuleInterfaceEntity> result = new ArrayList<DBModuleInterfaceEntity>();
        for (Object id : ids) {
            for (DBModuleInterfaceEntity entity : interfaces) {
                if (!entity.getId().toString().equals(id.toString())) continue;
                result.add(entity);
            }
        }
        return result;
    }

    @ApidocComment(value="\u4fdd\u5b58\u5df2\u6253\u5f00\u7684\u63a5\u53e3\u96c6\u5408")
    @PostMapping(value={"/setOpendInterfaceIds"})
    @AccessAuth(code=1000)
    public void setOpendInterfaceIds(@RequestBody IdListDto dto) {
        List<Long> ids = dto.getIds();
        DBUserEntity user = (DBUserEntity)this.userService.getById(CurrentSession.getCurrentUser().getId());
        String lastOpendInterfaceIds = user.getLastOpendInterfaceIds();
        if (StringUtil.isEmpty(lastOpendInterfaceIds)) {
            lastOpendInterfaceIds = "{}";
        }
        Map<String, Object> map = JsonUtil.jsonToMap(lastOpendInterfaceIds);
        map.put(dto.getProjectId().toString(), ids);
        user.setLastOpendInterfaceIds(JsonUtil.beanToJson(map));
        this.userService.updateById(user);
        CurrentSession.getCurrentUser().setLastOpendInterfaceIds(JsonUtil.beanToJson(map));
    }

    @ApidocComment(value="\u83b7\u53d6\u8bf7\u6c42\u73af\u5883\u5217\u8868")
    @PostMapping(value={"/getHosts"})
    @AccessAuth(code=1000)
    public List<DBModuleHostEntity> getHosts() {
        DBModuleHostEntity entity = new DBModuleHostEntity();
        List list = this.hostService.list((Wrapper)Wrappers.lambdaQuery((Object)entity));
        list.sort(Comparator.comparing(DBModuleHostEntity::getCanDelete));
        return list;
    }

    @ApidocComment(value="\u6dfb\u52a0\u8bf7\u6c42\u73af\u5883")
    @PostMapping(value={"/addHost"})
    @AccessAuth(code=1000)
    public void addHost(@RequestBody DBModuleHostEntity hostEntity) {
        this.hostService.save(hostEntity);
    }

    @ApidocComment(value="\u4fee\u6539\u8bf7\u6c42\u73af\u5883")
    @PostMapping(value={"/updateHost"})
    @AccessAuth(code=1000)
    public void updateHost(@RequestBody DBModuleHostEntity hostEntity) {
        AssertUtil.isNull((Object)hostEntity.getId(), "\u73af\u5883id\u4e0d\u80fd\u4e3a\u7a7a");
        this.hostService.updateById(hostEntity);
    }

    @ApidocComment(value="\u5220\u9664\u8bf7\u6c42\u73af\u5883")
    @PostMapping(value={"/delHost"})
    @AccessAuth(code=1000)
    public void delHost(@RequestBody IdDto dto) {
        this.hostService.removeById(dto.getId());
    }

    @ApidocComment(value="\u83b7\u53d6\u5168\u90e8\u73af\u5883\u53d8\u91cf")
    @PostMapping(value={"/getEnvsgs"})
    @AccessAuth(code=1000)
    public List<DBMouduleEnvEntity> getEnvsgs(@RequestBody BaseDbEntity dto) {
        DBMouduleEnvEntity entity = new DBMouduleEnvEntity();
        entity.setUserId(CurrentSession.getCurrentUser().getId());
        List self = this.envService.list((Wrapper)Wrappers.lambdaQuery((Object)entity));
        entity.setUserId(null);
        entity.setType(1);
        List global = this.envService.list((Wrapper)Wrappers.lambdaQuery((Object)entity));
        return this.mergin(global, self);
    }

    @ApidocComment(value="\u6dfb\u52a0\u73af\u5883\u53d8\u91cf")
    @PostMapping(value={"/addEnv"})
    @AccessAuth(code=1000)
    public void addEnv(@RequestBody DBMouduleEnvEntity env) {
        env.setUserId(CurrentSession.getCurrentUser().getId());
        DBMouduleEnvEntity query = new DBMouduleEnvEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(env.getKey());
        query = (DBMouduleEnvEntity)this.envService.getOne((Wrapper)Wrappers.lambdaQuery((Object)query), false);
        if (query != null) {
            this.envService.removeById(query.getId());
        }
        this.envService.save(env);
    }

    @ApidocComment(value="\u4fee\u6539\u73af\u5883\u53d8\u91cf")
    @PostMapping(value={"/updateEnv"})
    @AccessAuth(code=1000)
    public void updateEnv(@RequestBody DBMouduleEnvEntity env) {
        AssertUtil.isNull((Object)env.getId(), "\u73af\u5883\u53d8\u91cfid\u4e0d\u80fd\u4e3a\u7a7a");
        DBMouduleEnvEntity query = new DBMouduleEnvEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(env.getKey());
        query = (DBMouduleEnvEntity)this.envService.getOne((Wrapper)Wrappers.lambdaQuery((Object)query), false);
        if (query != null) {
            this.envService.removeById(query.getId());
        }
        this.envService.save(env);
    }

    @ApidocComment(value="\u5220\u9664\u73af\u5883\u53d8\u91cf")
    @PostMapping(value={"/delEnv"})
    @AccessAuth(code=1000)
    public void delEnv(@RequestBody IdDto dto) {
        this.envService.removeById(dto.getId());
    }

    @ApidocComment(value="\u83b7\u53d6\u53c2\u6570\u7684\u5916\u5305\u88c5\u5217\u8868")
    @PostMapping(value={"/getOutPackages"})
    @AccessAuth(code=1000)
    public List<DBModuleOutPackageEntity> getOutPackages(@RequestBody GetOutPackagesDto dto) {
        DBModuleOutPackageEntity entity = new DBModuleOutPackageEntity();
        entity.setType(dto.getType());
        return this.outPackageService.list((Wrapper)Wrappers.lambdaQuery((Object)entity));
    }

    @ApidocComment(value="\u65b0\u589e\u53c2\u6570\u7684\u5916\u5305\u88c5")
    @PostMapping(value={"/addOutPackages"})
    @AccessAuth(code=1000)
    public void addOutPackages(@RequestBody DBModuleOutPackageEntity entity) {
        if (entity.getDefaultStatus() == 1) {
            DBModuleOutPackageEntity query = new DBModuleOutPackageEntity();
            query.setDefaultStatus(entity.getDefaultStatus());
            query.setType(entity.getType());
            query = (DBModuleOutPackageEntity)this.outPackageService.getOne((Wrapper)Wrappers.lambdaQuery((Object)query), false);
            AssertUtil.isTrue(query != null, "\u5916\u5305\u88c5\u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\u5305\u88c5\u503c");
        }
        String key = entity.getKey();
        DBModuleOutPackageEntity find = new DBModuleOutPackageEntity();
        find.setKey(key);
        find.setType(entity.getType());
        find = (DBModuleOutPackageEntity)this.outPackageService.getOne((Wrapper)Wrappers.lambdaQuery((Object)find), false);
        if (find != null) {
            this.outPackageService.removeById(find.getId());
        }
        this.outPackageService.save(entity);
    }

    @ApidocComment(value="\u4fee\u6539\u53c2\u6570\u7684\u5916\u5305\u88c5")
    @PostMapping(value={"/updateOutPackages"})
    @AccessAuth(code=1000)
    public void updateOutPackages(@RequestBody DBModuleOutPackageEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "\u5916\u5305\u88c5id\u4e0d\u80fd\u4e3a\u7a7a");
        DBModuleOutPackageEntity query = (DBModuleOutPackageEntity)this.outPackageService.getById(entity.getId());
        if (entity.getDefaultStatus() != null && entity.getDefaultStatus() == 1 && !entity.getDefaultStatus().equals(query.getDefaultStatus())) {
            DBModuleOutPackageEntity find = new DBModuleOutPackageEntity();
            find.setDefaultStatus(entity.getDefaultStatus());
            find.setType(entity.getType());
            find = (DBModuleOutPackageEntity)this.outPackageService.getOne((Wrapper)Wrappers.lambdaQuery((Object)query), false);
            AssertUtil.isTrue(find != null, "\u5916\u5305\u88c5\u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\u5305\u88c5\u503c");
        }
        String key = entity.getKey();
        DBModuleOutPackageEntity find = new DBModuleOutPackageEntity();
        find.setKey(key);
        find.setType(entity.getType());
        find = (DBModuleOutPackageEntity)this.outPackageService.getOne((Wrapper)Wrappers.lambdaQuery((Object)query), false);
        if (find != null && !find.getId().equals(entity.getId())) {
            this.outPackageService.removeById(find.getId());
        }
        this.outPackageService.updateById(entity);
    }

    @ApidocComment(value="\u5220\u9664\u53c2\u6570\u7684\u5916\u5305\u88c5")
    @PostMapping(value={"/delOutPackages"})
    @AccessAuth(code=1000)
    public void delOutPackages(@RequestBody IdDto dto) {
        this.outPackageService.removeById(dto.getId());
    }

    @ApidocComment(value="\u6a21\u62df\u8bf7\u6c42")
    @PostMapping(value={"/mock"})
    @AccessAuth(code=1000)
    public Object mock(String path, String tag) {
        DBModuleInterfaceEntity interfaceEntity = new DBModuleInterfaceEntity();
        if (!StringUtil.isEmpty(path)) {
            interfaceEntity.setRequestUrl(path);
        } else {
            interfaceEntity.setInterfaceUnique(tag);
        }
        interfaceEntity = (DBModuleInterfaceEntity)this.interfaceService.getOne((Wrapper)Wrappers.lambdaQuery((Object)interfaceEntity), false);
        AssertUtil.isNull((Object)interfaceEntity, "\u672a\u77e5\u63a5\u53e3");
        DBInterfaceParamEntity entity = new DBInterfaceParamEntity();
        entity.setInterfaceId(interfaceEntity.getId());
        entity = (DBInterfaceParamEntity)this.interfaceParamService.getOne((Wrapper)Wrappers.lambdaQuery((Object)entity), false);
        AssertUtil.isNull((Object)entity, "\u672a\u77e5\u63a5\u53e3");
        MockReaderProvider operator = ProjectContext.mockTemplateOperator;
        MockProcess2 mocker = MockProcess2.with(operator);
        mocker.setMockArraySize(ProjectContext.allConfiguration.getConfiguration().getMockArraySize());
        Object contentMock = mocker.mockByApiParams(entity.getResponseParamJson());
        DBProjectEntity project = new DBProjectEntity();
        project.setId(CurrentSession.getCurrentProjectId());
        project = (DBProjectEntity)this.projectService.getOne((Wrapper)Wrappers.lambdaQuery((Object)project), false);
        if (project == null || project.getEnableResPackage() == 0) {
            return contentMock;
        }
        if (interfaceEntity.getEnableResPackage() == 0) {
            return contentMock;
        }
        DBModuleOutPackageEntity packages = new DBModuleOutPackageEntity();
        packages.setType(1);
        List resPackages = this.outPackageService.list((Wrapper)Wrappers.lambdaQuery((Object)packages));
        if (resPackages == null || resPackages.isEmpty()) {
            return contentMock;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (DBModuleOutPackageEntity resPackage : resPackages) {
            if (resPackage.getDefaultStatus() == 1) {
                result.put(resPackage.getKey(), contentMock);
                continue;
            }
            result.put(resPackage.getKey(), resPackage.getVal());
        }
        return result;
    }

    @ApidocComment(value="\u83b7\u53d6\u5168\u5c40header")
    @PostMapping(value={"/getHeaders"})
    @AccessAuth(code=1000)
    public List<DBModuleHeaderEntity> getHeaders(@RequestBody BaseDbEntity dto) {
        DBModuleHeaderEntity entity = new DBModuleHeaderEntity();
        entity.setUserId(CurrentSession.getCurrentUser().getId());
        List self = this.headerService.list((Wrapper)Wrappers.lambdaQuery((Object)entity));
        entity.setUserId(null);
        entity.setType(1);
        List gloabel = this.headerService.list((Wrapper)Wrappers.lambdaQuery((Object)entity));
        return this.mergin(self, gloabel);
    }

    @ApidocComment(value="\u6dfb\u52a0header")
    @PostMapping(value={"/addHeader"})
    @AccessAuth(code=1000)
    public void addHeader(@RequestBody DBModuleHeaderEntity entity) {
        entity.setUserId(CurrentSession.getCurrentUser().getId());
        entity.setModuleId(CurrentSession.getCurrentModuleId());
        AssertUtil.isEmpty(entity.getKey(), "key\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isEmpty(entity.getVal(), "val\u4e0d\u80fd\u4e3a\u7a7a");
        DBModuleHeaderEntity query = new DBModuleHeaderEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(entity.getKey());
        query = (DBModuleHeaderEntity)this.headerService.getOne((Wrapper)Wrappers.lambdaQuery((Object)query));
        if (query != null) {
            this.headerService.removeById(query.getId());
        }
        this.headerService.save(entity);
    }

    @ApidocComment(value="\u5220\u9664header")
    @PostMapping(value={"/delHeader"})
    @AccessAuth(code=1000)
    public void delHeader(@RequestBody IdDto dto) {
        this.headerService.removeById(dto.getId());
    }

    @ApidocComment(value="\u4fee\u6539header")
    @PostMapping(value={"/updateHeader"})
    @AccessAuth(code=1000)
    public void updateHeader(@RequestBody DBModuleHeaderEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "id\u4e0d\u80fd\u4e3a\u7a7a");
        DBModuleHeaderEntity query = new DBModuleHeaderEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(entity.getKey());
        query = (DBModuleHeaderEntity)this.headerService.getOne((Wrapper)Wrappers.lambdaQuery((Object)query), false);
        if (query != null && !query.getId().equals(entity.getId())) {
            this.headerService.removeById(query.getId());
        }
        this.headerService.updateById(entity);
    }

    private <T extends BaseDbEntity> List<T> mergin(List<T> li1, List<T> li2) {
        if (li1 == null) {
            li1 = new ArrayList<T>();
        }
        if (li2 == null) {
            li2 = new ArrayList<T>();
        }
        HashSet<Long> ids = new HashSet<Long>();
        ArrayList<BaseDbEntity> result = new ArrayList<BaseDbEntity>();
        li1.addAll(li2);
        for (BaseDbEntity t : li1) {
            boolean add = ids.add(t.getId());
            if (!add) continue;
            result.add(t);
        }
        return result;
    }
}

