/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.entity.auth;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.CollectionUtils;

public enum AuthModule {
    manualSync(10001, "\u540c\u6b65\u63a5\u53e3", "MANUALSYNC"),
    manualSyncAll(10002, "\u540c\u6b65\u5168\u90e8\u6587\u6863", "MANUALSYNCALL"),
    getInfo(20001, "\u67e5\u770b\u6587\u6863\u8bf4\u660e", "GETINFO", 1),
    updateInfo(20201, "\u4fee\u6539\u6587\u6863\u8bf4\u660e", "UPDATEINFO"),
    getOutPackage(20002, "\u67e5\u770b\u8fd4\u56de\u5916\u5305\u88c5", "GETOUTPACKAGE", 1),
    updateOutPackage(20301, "\u4fee\u6539\u8fd4\u56de\u5916\u5305\u88c5", "UPDATEOUTPACKAGE"),
    getControllers(30001, "\u67e5\u770b\u63a7\u5236\u5668\u5217\u8868", "GETCONTROLLERS", 1),
    findInterfaces(40001, "\u641c\u7d22\u63a5\u53e3", "FINDINTERFACES", 1),
    getInterfaces(40002, "\u67e5\u770b\u5168\u90e8\u63a5\u53e3", "GETINTERFACES", 1),
    addInterfaces(40101, "\u6dfb\u52a0\u63a5\u53e3", "ADDINTERFACES"),
    updateInteface(40201, "\u4fee\u6539\u63a5\u53e3\u4fe1\u606f", "UPDATEINTEFACE"),
    delInterfaces(40301, "\u5220\u9664\u63a5\u53e3", "DELINTERFACES"),
    mock(50001, "mock\u8fd4\u56de\u6570\u636e", "MOCK", 1),
    updateMock(50201, "\u4fee\u6539mock\u6570\u636e", "UPDATEMOCK"),
    getRequestParam(60001, "\u67e5\u770b\u8bf7\u6c42\u53c2\u6570", "GETREQUESTPARAM", 1),
    updateRequestParams(60201, "\u4fee\u6539\u8bf7\u6c42\u53c2\u6570", "UPDATEREQUESTPARAMS"),
    getResponseParam(70001, "\u67e5\u770b\u54cd\u5e94\u53c2\u6570", "GETRESPONSEPARAM", 1),
    updateResponseParams(70201, "\u4fee\u6539\u54cd\u5e94\u53c2\u6570", "UPDATERESPONSEPARAMS"),
    doUrl(80001, "\u771f\u5b9e\u73af\u5883\u8bf7\u6c42", "DOURL"),
    unknow(-1, "\u672a\u77e5\u529f\u80fd", "unknow");

    private Integer authCode;
    private Integer defaultStatus = 0;
    private String moduleRemark;
    private String moduleName;

    private AuthModule(Integer authCode, String moduleRemark, String moduleName) {
        this.authCode = authCode;
        this.moduleRemark = moduleRemark;
        this.moduleName = moduleName;
    }

    private AuthModule(Integer authCode, String moduleRemark, String moduleName, Integer defaultStatus) {
        this.authCode = authCode;
        this.moduleRemark = moduleRemark;
        this.moduleName = moduleName;
        this.defaultStatus = defaultStatus;
    }

    public static AuthModule getByCode(Integer code) {
        return Arrays.stream(AuthModule.values()).filter(am -> am.getAuthCode().equals(code)).findFirst().orElse(unknow);
    }

    public static List<Integer> allCode() {
        return Stream.of(AuthModule.values()).filter(am -> am != unknow).map(AuthModule::getAuthCode).collect(Collectors.toList());
    }

    public static List<AuthModule> allModule(List<Integer> codes) {
        List<AuthModule> authModules = Arrays.asList(AuthModule.values());
        if (CollectionUtils.isEmpty(codes)) {
            return authModules;
        }
        return authModules.stream().filter(am -> am != unknow).filter(m -> codes.contains(m.getAuthCode())).collect(Collectors.toList());
    }

    public static List<Integer> getDefaultAuthCodes() {
        return Stream.of(AuthModule.values()).filter(module -> module.getDefaultStatus() == 1).map(AuthModule::getAuthCode).collect(Collectors.toList());
    }

    public Integer getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(Integer authCode) {
        this.authCode = authCode;
    }

    public Integer getDefaultStatus() {
        return this.defaultStatus;
    }

    public void setDefaultStatus(Integer defaultStatus) {
        this.defaultStatus = defaultStatus;
    }

    public String getModuleRemark() {
        return this.moduleRemark;
    }

    public void setModuleRemark(String moduleRemark) {
        this.moduleRemark = moduleRemark;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }
}

