/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.content;

import cn.easyutil.easyapi.content.DBTableClassify;
import cn.easyutil.easyapi.content.SqlDriver;
import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.db.auth.DBDictEntity;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleAuthEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserTemporaryAuthEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBArticleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHeaderEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHostEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleOutPackageEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleScriptEntity;
import cn.easyutil.easyapi.entity.db.doc.DBMouduleEnvEntity;
import cn.easyutil.easyapi.entity.db.doc.DBParamEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestGroupEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestInfoEntity;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.mybatis.IBaseMapper;
import cn.easyutil.easyapi.mybatis.MybatisUtil;
import cn.easyutil.easyapi.mybatis.SqlExecMapper;
import cn.easyutil.easyapi.mybatis.mapper.ArticleMapper;
import cn.easyutil.easyapi.mybatis.mapper.ControllerMapper;
import cn.easyutil.easyapi.mybatis.mapper.DictMapper;
import cn.easyutil.easyapi.mybatis.mapper.EnvMapper;
import cn.easyutil.easyapi.mybatis.mapper.HeaderMapper;
import cn.easyutil.easyapi.mybatis.mapper.HostMapper;
import cn.easyutil.easyapi.mybatis.mapper.InterfaceMapper;
import cn.easyutil.easyapi.mybatis.mapper.InterfaceParamMapper;
import cn.easyutil.easyapi.mybatis.mapper.ModuleMapper;
import cn.easyutil.easyapi.mybatis.mapper.OutPackageMapper;
import cn.easyutil.easyapi.mybatis.mapper.ParamMapper;
import cn.easyutil.easyapi.mybatis.mapper.ProjectMapper;
import cn.easyutil.easyapi.mybatis.mapper.RoleAuthMapper;
import cn.easyutil.easyapi.mybatis.mapper.RoleMapper;
import cn.easyutil.easyapi.mybatis.mapper.RoleProjectMapper;
import cn.easyutil.easyapi.mybatis.mapper.ScriptMapper;
import cn.easyutil.easyapi.mybatis.mapper.SimpleUnitMapper;
import cn.easyutil.easyapi.mybatis.mapper.UserMapper;
import cn.easyutil.easyapi.mybatis.mapper.UserTemporaryAuthMapper;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum DBTables {
    project("EASYAPI_PROJECT", DBTableClassify.global, DBProjectEntity.class, ProjectMapper.class),
    dict("EASYAPI_DICT", DBTableClassify.global, DBDictEntity.class, DictMapper.class),
    roleAuth("EASYAPI_ROLE_AUTH", DBTableClassify.global, DBRoleAuthEntity.class, RoleAuthMapper.class),
    role("EASYAPI_ROLE", DBTableClassify.global, DBRoleEntity.class, RoleMapper.class),
    roleProject("EASYAPI_ROLE_PROJECTS", DBTableClassify.global, DBRoleProjectEntity.class, RoleProjectMapper.class),
    user("EASYAPI_USER", DBTableClassify.user, DBUserEntity.class, UserMapper.class),
    simpleUnit("EASYAPI_SIMPLE_UNIT", DBTableClassify.user, DBSimpleUnitEntity.class, SimpleUnitMapper.class),
    complexTest("EASYAPI_COMPLEX_TEST", DBTableClassify.user, DBComplexTestEntity.class, null),
    complexTestGroup("EASYAPI_COMPLEX_TEST_GROUP", DBTableClassify.user, DBComplexTestGroupEntity.class, null),
    complexTestInfo("EASYAPI_COMPLEX_TEST_INFO", DBTableClassify.user, DBComplexTestInfoEntity.class, null),
    interfaceParam("EASYAPI_INTERFACE_PARAM", DBTableClassify.doc, DBInterfaceParamEntity.class, InterfaceParamMapper.class),
    controllers("EASYAPI_MODULE_CONTROLLER", DBTableClassify.doc, DBModuleControllerEntity.class, ControllerMapper.class),
    module("EASYAPI_MODULE", DBTableClassify.global, DBModuleEntity.class, ModuleMapper.class),
    host("EASYAPI_MODULE_HOST", DBTableClassify.global, DBModuleHostEntity.class, HostMapper.class),
    interfaces("EASYAPI_MODULE_INTERFACE", DBTableClassify.doc, DBModuleInterfaceEntity.class, InterfaceMapper.class),
    outPackage("EASYAPI_MODULE_OUT_PACKAGE", DBTableClassify.user, DBModuleOutPackageEntity.class, OutPackageMapper.class),
    env("EASYAPI_MODULE_ENV", DBTableClassify.user, DBMouduleEnvEntity.class, EnvMapper.class),
    header("EASYAPI_MODULE_HEADER", DBTableClassify.user, DBModuleHeaderEntity.class, HeaderMapper.class),
    script("EASYAPI_MODULE_SCRIPT", DBTableClassify.user, DBModuleScriptEntity.class, ScriptMapper.class),
    param("EASYAPI_PARAM", DBTableClassify.doc, DBParamEntity.class, ParamMapper.class),
    userTemporaryAuth("EASYAPI_USER_TEMPORARY_AUTH", DBTableClassify.user, DBUserTemporaryAuthEntity.class, UserTemporaryAuthMapper.class),
    article("EASYAPI_ARTICLE", DBTableClassify.global, DBArticleEntity.class, ArticleMapper.class);

    private String tableName;
    private DBTableClassify classify;
    private Class<? extends BaseDbEntity> clazz;
    private Class<? extends IBaseMapper> mapper;

    private DBTables(String tableName, DBTableClassify classify, Class<? extends BaseDbEntity> clazz, Class<? extends IBaseMapper> mapper) {
        this.tableName = tableName;
        this.classify = classify;
        this.clazz = clazz;
        this.mapper = mapper;
    }

    public String dropSql() {
        return "DROP TABLE IF EXISTS " + this.tableName + ";";
    }

    public String clearSql() {
        return "TRUNCATE table " + this.tableName + ";";
    }

    public String tableDDL(SqlDriver driver) {
        Class<? extends BaseDbEntity> clazz = this.clazz;
        List<DDL> DDLs = this.getAllFields(clazz);
        if (DDLs.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE if not exists ").append("`").append(this.tableName).append("`");
        sb.append("(").append("\n");
        for (DDL DDL2 : DDLs) {
            sb.append("\n");
            String ddl = DDL2.ddl();
            if (driver == SqlDriver.MYSQL) {
                ddl = ddl.replace(" BLOB ", " LONGBLOB ").replace(" blob ", " longblob ");
            }
            sb.append(ddl).append(",");
        }
        sb.append("\n").append("PRIMARY KEY (`ID`)").append("\n");
        sb.append(")");
        return sb.toString();
    }

    public void replenishField() {
        SqlExecMapper mapper = MybatisUtil.getMapper(SqlExecMapper.class);
        List<Map<String, Object>> query = mapper.execQuery("SHOW COLUMNS FROM " + this.tableName);
        Set<Object> tableFields = new HashSet();
        if (query != null) {
            tableFields = query.stream().map(m -> {
                if (m.get("FIELD") != null) {
                    return m.get("FIELD").toString();
                }
                if (m.get("Field") != null) {
                    return m.get("Field").toString();
                }
                if (m.get("field") != null) {
                    return m.get("field").toString();
                }
                return "";
            }).collect(Collectors.toSet());
        }
        List<DDL> allFields = this.getAllFields(this.clazz);
        for (DDL DDL2 : allFields) {
            String name = DDL2.value();
            if (StringUtil.isEmpty(name) || tableFields.contains(name)) continue;
            mapper.execUpdate("ALTER TABLE " + this.tableName + " ADD " + DDL2.ddl());
        }
    }

    public List<DDL> getAllFields(Class<? extends BaseDbEntity> clazz) {
        ArrayList<DDL> DDLs = new ArrayList<DDL>();
        Class<? extends BaseDbEntity> cl = clazz;
        while (!cl.equals(Object.class)) {
            Field[] fields;
            for (Field field : fields = cl.getDeclaredFields()) {
                DDL DDL2 = field.getDeclaredAnnotation(DDL.class);
                if (DDL2 == null) continue;
                DDLs.add(DDL2);
            }
            cl = cl.getSuperclass();
        }
        return DDLs;
    }

    public static List<DBTables> getByClassify(DBTableClassify classify) {
        ArrayList<DBTables> result = new ArrayList<DBTables>();
        for (DBTables value : DBTables.values()) {
            if (value.classify != classify) continue;
            result.add(value);
        }
        return result;
    }

    public String getTableName() {
        return this.tableName;
    }

    public DBTableClassify getClassify() {
        return this.classify;
    }

    public Class<? extends BaseDbEntity> getClazz() {
        return this.clazz;
    }

    public Class<? extends IBaseMapper> getMapper() {
        return this.mapper;
    }
}

