/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.content;

import cn.easyutil.easyapi.content.AuthModuleBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AuthModuleButtonsEnum {
    doc_interface("\u6587\u6863-\u63a5\u53e3\u8be6\u60c5", "doc_interface", "doc_interface", 1),
    doc_interface_source("\u67e5\u770b\u6e90\u7801", "doc_interface", "doc_interface_source"),
    doc_interface_update("\u4fee\u6539\u63a5\u53e3\u4fe1\u606f", "doc_interface", "doc_interface_update"),
    doc_interface_del("\u5220\u9664\u63a5\u53e3", "doc_interface", "doc_interface_del"),
    doc_request("\u6587\u6863-\u8bf7\u6c42\u53c2\u6570", "doc_request", "doc_request", 1),
    doc_request_template("\u67e5\u770b\u793a\u4f8b", "doc_request", "doc_request_template", 1),
    doc_request_export("\u5bfc\u51fa\u4ee3\u7801", "doc_request", "doc_request_export", 1),
    doc_request_update("\u7f16\u8f91\u53c2\u6570", "doc_request", "doc_request_update"),
    doc_response("\u6587\u6863-\u54cd\u5e94\u53c2\u6570", "doc_response", "doc_response", 1),
    doc_response_template("\u67e5\u770b\u793a\u4f8b", "doc_response", "doc_response_template", 1),
    doc_response_export("\u5bfc\u51fa\u4ee3\u7801", "doc_response", "doc_response_export", 1),
    doc_response_update("\u7f16\u8f91\u53c2\u6570", "doc_response", "doc_response_update"),
    doc_mock("\u6587\u6863-\u6a21\u62df\u8bf7\u6c42", "doc_mock", "doc_mock", 1),
    manage_sync("\u7ba1\u7406-\u540c\u6b65\u7ba1\u7406", "manage_sync", "manage_sync"),
    manage_sync_update("\u4fee\u6539\u540c\u6b65\u5bc6\u94a5", "manage_sync", "manage_sync_update"),
    manage_sync_create("\u521b\u5efa\u540c\u6b65\u4efb\u52a1", "manage_sync", "manage_sync_create"),
    manage_project("\u7ba1\u7406-\u9879\u76ee\u7ba1\u7406", "manage_project", "manage_project"),
    manage_project_update("\u4fee\u6539\u9879\u76ee\u4fe1\u606f", "manage_project", "manage_project_update"),
    manage_project_export("\u5bfc\u51fa\u9879\u76ee", "manage_project", "manage_project_export"),
    manage_user("\u7ba1\u7406-\u7528\u6237\u7ba1\u7406", "manage_user", "manage_user"),
    manage_user_create("\u521b\u5efa\u7528\u6237", "manage_user", "manage_user_create"),
    manage_user_auth("\u7528\u6237\u6388\u6743", "manage_user", "manage_user_auth"),
    manage_user_update("\u4fee\u6539\u7528\u6237\u4fe1\u606f", "manage_user", "manage_user_update"),
    manage_user_del("\u5220\u9664\u7528\u6237", "manage_user", "manage_user_del"),
    manage_header("\u7ba1\u7406-\u8bf7\u6c42\u5934\u7ba1\u7406", "manage_header", "manage_header", 1),
    manage_header_create("\u6dfb\u52a0\u8bf7\u6c42\u5934", "manage_header", "manage_header_create", 1),
    manage_header_update("\u4fee\u6539\u8bf7\u6c42\u5934", "manage_header", "manage_header_update", 1),
    manage_header_del("\u5220\u9664\u8bf7\u6c42\u5934", "manage_header", "manage_header_del", 1),
    manage_host("\u7ba1\u7406-\u8bf7\u6c42\u73af\u5883\u7ba1\u7406", "manage_host", "manage_host"),
    manage_host_create("\u6dfb\u52a0\u8bf7\u6c42\u73af\u5883", "manage_host", "manage_host_create"),
    manage_host_update("\u4fee\u6539\u8bf7\u6c42\u73af\u5883", "manage_host", "manage_host_update"),
    manage_host_del("\u5220\u9664\u8bf7\u6c42\u73af\u5883", "manage_host", "manage_host_del"),
    manage_env("\u7ba1\u7406-\u73af\u5883\u53d8\u91cf\u7ba1\u7406", "manage_env", "manage_env", 1),
    manage_env_create("\u6dfb\u52a0\u73af\u5883\u53d8\u91cf", "manage_env", "manage_env_create", 1),
    manage_env_update("\u4fee\u6539\u73af\u5883\u53d8\u91cf", "manage_env", "manage_env_update", 1),
    manage_env_del("\u5220\u9664\u73af\u5883\u53d8\u91cf", "manage_env", "manage_env_del", 1),
    manage_script("\u7ba1\u7406-\u811a\u672c\u7ba1\u7406", "manage_script", "manage_script", 1),
    manage_script_create("\u6dfb\u52a0\u811a\u672c", "manage_script", "manage_script_create", 1),
    manage_script_update("\u4fee\u6539\u811a\u672c", "manage_script", "manage_script_update", 1),
    manage_script_del("\u5220\u9664\u811a\u672c", "manage_script", "manage_script_del", 1),
    manage_package("\u7ba1\u7406-\u53c2\u6570\u5305\u88c5\u7ba1\u7406", "manage_package", "manage_package", 1),
    manage_package_create("\u6dfb\u52a0\u53c2\u6570\u5305\u88c5", "manage_package", "manage_package_create", 1),
    manage_package_update("\u4fee\u6539\u53c2\u6570\u5305\u88c5", "manage_package", "manage_package_update", 1),
    manage_package_del("\u5220\u9664\u53c2\u6570\u5305\u88c5", "manage_package", "manage_package_del", 1),
    unknown(null, null, null);

    private final String name;
    private final String module;
    private final String code;
    private final Integer defaultStatus;

    private AuthModuleButtonsEnum(String name, String module, String code, Integer defaultStatus) {
        this.name = name;
        this.module = module;
        this.code = code;
        this.defaultStatus = defaultStatus;
    }

    private AuthModuleButtonsEnum(String name, String module, String code) {
        this(name, module, code, 0);
    }

    public static List<AuthModuleButtonsEnum> getByModule(String module) {
        ArrayList<AuthModuleButtonsEnum> list = new ArrayList<AuthModuleButtonsEnum>();
        for (AuthModuleButtonsEnum value : AuthModuleButtonsEnum.values()) {
            if (!value.getModule().equals(module)) continue;
            list.add(value);
        }
        return list;
    }

    public static AuthModuleButtonsEnum getByCode(String code) {
        for (AuthModuleButtonsEnum value : AuthModuleButtonsEnum.values()) {
            if (!value.getModule().equals(code)) continue;
            return value;
        }
        return null;
    }

    public static List<AuthModuleBean> getModules(Set<String> checked) {
        ArrayList<AuthModuleBean> list = new ArrayList<AuthModuleBean>();
        List modules = Stream.of(AuthModuleButtonsEnum.values()).filter(e -> e.getModule() != null && e.getModule().equals(e.getCode())).collect(Collectors.toList());
        for (AuthModuleButtonsEnum module : modules) {
            AuthModuleBean bean = new AuthModuleBean();
            bean.setModuleName(module.getName());
            bean.setModuleCode(module.getCode());
            bean.setChecked(0);
            if (checked != null && checked.contains(module.getCode())) {
                bean.setChecked(1);
            }
            bean.setChildren(new ArrayList<AuthModuleBean>());
            for (AuthModuleButtonsEnum value : AuthModuleButtonsEnum.values()) {
                if (value == unknown || !value.getModule().equals(module.getCode()) || value.getCode().equals(module.getCode())) continue;
                AuthModuleBean children = new AuthModuleBean();
                children.setChecked(0);
                if (checked != null && checked.contains(value.getCode())) {
                    children.setChecked(1);
                }
                children.setModuleName(value.getName());
                children.setModuleCode(value.getCode());
                bean.getChildren().add(children);
            }
            list.add(bean);
        }
        return list;
    }

    public String getName() {
        return this.name;
    }

    public String getModule() {
        return this.module;
    }

    public String getCode() {
        return this.code;
    }

    public Integer getDefaultStatus() {
        return this.defaultStatus;
    }
}

