/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.EasyapiRun;
import cn.easyutil.easyapi.configuration.AbstractConfigurationCreator;
import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiBaseConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiDataConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiGlobalRequestConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiGlobalResponseConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiUserConfiguration;
import cn.easyutil.easyapi.configuration.SpringRunEnvClassComponent;
import cn.easyutil.easyapi.configuration.filter.EasyApiBeanReaderFilter;
import cn.easyutil.easyapi.configuration.filter.EasyApiControllerReaderFilter;
import cn.easyutil.easyapi.configuration.filter.EasyApiInterfaceReaderFilter;
import cn.easyutil.easyapi.configuration.filter.EasyApiMockReaderFilter;
import cn.easyutil.easyapi.configuration.filter.EasyApiRequestReaderFilter;
import cn.easyutil.easyapi.configuration.filter.EasyApiResponseReaderFilter;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.handler.BaseHandlerChain;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ApiExtra;
import cn.easyutil.easyapi.handler.reader.beans.BeanReaderHandler;
import cn.easyutil.easyapi.handler.reader.controllers.ControllerReaderHandler;
import cn.easyutil.easyapi.handler.reader.interfaces.InterfaceReaderHandler;
import cn.easyutil.easyapi.handler.reader.mocks.MockReaderHandler;
import cn.easyutil.easyapi.handler.reader.requests.RequestReaderHandler;
import cn.easyutil.easyapi.handler.reader.responses.ResponseReaderHandler;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={EasyApiBaseConfiguration.class, EasyApiDataConfiguration.class, EasyApiUserConfiguration.class, EasyApiGlobalResponseConfiguration.class, EasyApiGlobalRequestConfiguration.class, EasyApiBeanReaderFilter.class, EasyApiControllerReaderFilter.class, EasyApiInterfaceReaderFilter.class, EasyApiMockReaderFilter.class, EasyApiRequestReaderFilter.class, EasyApiResponseReaderFilter.class, SpringRunEnvClassComponent.class})
@ConditionalOnMissingBean(value={AbstractConfigurationCreator.class})
@ConditionalOnProperty(prefix="easyapi", name={"enable"}, havingValue="true")
public class EasyApiAutoConfiguration
implements InitializingBean {
    @Resource
    private EasyApiBaseConfiguration configuration;
    @Resource
    private EasyApiDataConfiguration dataConfiguration;
    @Resource
    private EasyApiUserConfiguration userConfiguration;
    @Resource
    private EasyApiGlobalRequestConfiguration requestConfiguration;
    @Resource
    private EasyApiGlobalResponseConfiguration responseConfiguration;
    @Resource
    private EasyApiBeanReaderFilter beanFilter;
    @Resource
    private EasyApiControllerReaderFilter controllerFilter;
    @Resource
    private EasyApiInterfaceReaderFilter interfaceFilter;
    @Resource
    private EasyApiMockReaderFilter mockFilter;
    @Resource
    private EasyApiRequestReaderFilter requestFilter;
    @Resource
    private EasyApiResponseReaderFilter responseFilter;
    @Resource
    private ApplicationContext applicationContext;

    public void afterPropertiesSet() {
        AllConfiguration all = new AllConfiguration();
        all.setConfiguration(this.configuration);
        all.setDataConfiguration(this.dataConfiguration);
        all.setUserConfiguration(this.userConfiguration);
        all.setGlobalRequestConfiguration(this.requestConfiguration);
        all.setGlobalResponseConfiguration(this.responseConfiguration);
        all.setBeanFilter(this.beanFilter);
        all.setControllerFilter(this.controllerFilter);
        all.setInterfaceFilter(this.interfaceFilter);
        all.setMockFilter(this.mockFilter);
        all.setRequestFilter(this.requestFilter);
        all.setResponseFilter(this.responseFilter);
        this.processBeanFilter();
        this.processControllerFilter();
        this.processInterfaceFilter();
        this.processMockFilter();
        this.processRequestFilter();
        this.processResponseFilter();
        EasyapiRun run = new EasyapiRun(all, this.applicationContext);
        run.run();
    }

    private void processBeanFilter() {
        if (this.beanFilter == null) {
            return;
        }
        this.beanFilter.getCondition().forEach(chain -> this.addChain(BeanReaderHandler.getConditionHandlers(), (Class)chain));
        this.beanFilter.getDescription().forEach(chain -> this.addChain(BeanReaderHandler.getDescriptionHandlers(), (Class)chain));
        this.beanFilter.getIgnore().forEach(chain -> this.addChain(BeanReaderHandler.getIgnoreHandlers(), (Class)chain));
        this.beanFilter.getJavaType().forEach(chain -> this.addChain(BeanReaderHandler.getJavaTypeHandlers(), (Class)chain));
        this.beanFilter.getMockTemplate().forEach(chain -> this.addChain(BeanReaderHandler.getMockTemplateHandlers(), (Class)chain));
        this.beanFilter.getName().forEach(chain -> this.addChain(BeanReaderHandler.getNameHandlers(), (Class)chain));
        this.beanFilter.getParam().forEach(chain -> this.addChain(BeanReaderHandler.getParamHandlers(), (Class)chain));
        this.beanFilter.getRenewType().forEach(chain -> this.addChain(BeanReaderHandler.getRenewTypeHandlers(), (Class)chain));
        this.beanFilter.getRequired().forEach(chain -> this.addChain(BeanReaderHandler.getRequiredHandlers(), (Class)chain));
        this.beanFilter.getShow().forEach(chain -> this.addChain(BeanReaderHandler.getShowHandlers(), (Class)chain));
        this.beanFilter.getType().forEach(chain -> this.addChain(BeanReaderHandler.getTypeHandlers(), (Class)chain));
    }

    private void processControllerFilter() {
        if (this.controllerFilter == null) {
            return;
        }
        this.controllerFilter.getAuthor().forEach(chain -> this.addChain(ControllerReaderHandler.getAuthorHandlers(), (Class)chain));
        this.controllerFilter.getDescription().forEach(chain -> this.addChain(ControllerReaderHandler.getDescriptionHandlers(), (Class)chain));
        this.controllerFilter.getIgnore().forEach(chain -> this.addChain(ControllerReaderHandler.getIgnoreHandlers(), (Class)chain));
        this.controllerFilter.getPath().forEach(chain -> this.addChain(ControllerReaderHandler.getPathHandlers(), (Class)chain));
        this.controllerFilter.getScan().forEach(chain -> this.addChain(ControllerReaderHandler.getScanHandlers(), (Class)chain));
        this.controllerFilter.getShow().forEach(chain -> this.addChain(ControllerReaderHandler.getShowHandlers(), (Class)chain));
        this.controllerFilter.getName().forEach(chain -> this.addChain(ControllerReaderHandler.getNameHandlers(), (Class)chain));
    }

    private void processInterfaceFilter() {
        if (this.interfaceFilter == null) {
            return;
        }
        this.interfaceFilter.getBodyType().forEach(chain -> this.addChain(InterfaceReaderHandler.getBodyTypeHandlers(), (Class)chain));
        this.interfaceFilter.getSearch().forEach(chain -> this.addChain(InterfaceReaderHandler.getSearchHandlers(), (Class)chain));
        this.interfaceFilter.getDescription().forEach(chain -> this.addChain(InterfaceReaderHandler.getDescriptionHandlers(), (Class)chain));
        this.interfaceFilter.getEnableReqPackage().forEach(chain -> this.addChain(InterfaceReaderHandler.getEnableReqPackageHandlers(), (Class)chain));
        this.interfaceFilter.getEnableResPackage().forEach(chain -> this.addChain(InterfaceReaderHandler.getEnableResPackageHandlers(), (Class)chain));
        this.interfaceFilter.getIgnore().forEach(chain -> this.addChain(InterfaceReaderHandler.getIgnoreHandlers(), (Class)chain));
        this.interfaceFilter.getRenewType().forEach(chain -> this.addChain(InterfaceReaderHandler.getRenewTypeHandlers(), (Class)chain));
        this.interfaceFilter.getRequestMethod().forEach(chain -> this.addChain(InterfaceReaderHandler.getRequestMethodHandlers(), (Class)chain));
        this.interfaceFilter.getRequestNote().forEach(chain -> this.addChain(InterfaceReaderHandler.getRequestNoteHandlers(), (Class)chain));
        this.interfaceFilter.getUrl().forEach(chain -> this.addChain(InterfaceReaderHandler.getUrlHandlers(), (Class)chain));
        this.interfaceFilter.getResponseNote().forEach(chain -> this.addChain(InterfaceReaderHandler.getResponseNoteHandlers(), (Class)chain));
        this.interfaceFilter.getScan().forEach(chain -> this.addChain(InterfaceReaderHandler.getScanHandlers(), (Class)chain));
        this.interfaceFilter.getShow().forEach(chain -> this.addChain(InterfaceReaderHandler.getShowHandlers(), (Class)chain));
        this.interfaceFilter.getName().forEach(chain -> this.addChain(InterfaceReaderHandler.getNameHandlers(), (Class)chain));
        this.interfaceFilter.getUnique().forEach(chain -> this.addChain(InterfaceReaderHandler.getUniqueHandlers(), (Class)chain));
        this.interfaceFilter.getVerifyMockTag().forEach(chain -> this.addChain(InterfaceReaderHandler.getVerifyMockTagHandlers(), (Class)chain));
    }

    private void processMockFilter() {
        if (this.mockFilter == null) {
            return;
        }
        this.mockFilter.getMock().forEach(chain -> this.addChain(MockReaderHandler.getMockHandlers(), (Class)chain));
    }

    private void processRequestFilter() {
        if (this.requestFilter == null) {
            return;
        }
        this.requestFilter.getCondition().forEach(chain -> this.addChain(RequestReaderHandler.getConditionHandlers(), (Class)chain));
        this.requestFilter.getDescription().forEach(chain -> this.addChain(RequestReaderHandler.getDescriptionHandlers(), (Class)chain));
        this.requestFilter.getIgnore().forEach(chain -> this.addChain(RequestReaderHandler.getIgnoreHandlers(), (Class)chain));
        this.requestFilter.getMockTemplate().forEach(chain -> this.addChain(RequestReaderHandler.getMockTemplateHandlers(), (Class)chain));
        this.requestFilter.getName().forEach(chain -> this.addChain(RequestReaderHandler.getNameHandlers(), (Class)chain));
        this.requestFilter.getParam().forEach(chain -> this.addChain(RequestReaderHandler.getParamHandlers(), (Class)chain));
        this.requestFilter.getRequired().forEach(chain -> this.addChain(RequestReaderHandler.getRequiredHandlers(), (Class)chain));
        this.requestFilter.getShow().forEach(chain -> this.addChain(RequestReaderHandler.getShowHandlers(), (Class)chain));
        this.requestFilter.getType().forEach(chain -> this.addChain(RequestReaderHandler.getTypeHandlers(), (Class)chain));
    }

    private void processResponseFilter() {
        if (this.responseFilter == null) {
            return;
        }
        this.responseFilter.getDescription().forEach(chain -> this.addChain(ResponseReaderHandler.getDescriptionHandlers(), (Class)chain));
        this.responseFilter.getIgnore().forEach(chain -> this.addChain(ResponseReaderHandler.getIgnoreHandlers(), (Class)chain));
        this.responseFilter.getMockTemplate().forEach(chain -> this.addChain(ResponseReaderHandler.getMockTemplateHandlers(), (Class)chain));
        this.responseFilter.getRequired().forEach(chain -> this.addChain(ResponseReaderHandler.getRequiredHandlers(), (Class)chain));
        this.responseFilter.getShow().forEach(chain -> this.addChain(ResponseReaderHandler.getShowHandlers(), (Class)chain));
        this.responseFilter.getReturnType().forEach(chain -> this.addChain(ResponseReaderHandler.getTypeHandlers(), (Class)chain));
    }

    private <E extends ApiExtra, T> void addChain(List<HandlerChain<E, T>> list, Class clazz) {
        try {
            HandlerChain chain = (HandlerChain)clazz.newInstance();
            BaseHandlerChain.addChain(list, chain);
        }
        catch (Exception e) {
            throw new ApidocException(e);
        }
    }
}

