/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.EasyapiRun;
import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.ConfigurationCreator;
import cn.easyutil.easyapi.configuration.EasyApiAutoConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiBaseConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiDataConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiUserConfiguration;
import cn.easyutil.easyapi.configuration.SpringRunEnvClassComponent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Import;

@Import(value={SpringRunEnvClassComponent.class})
@ConditionalOnMissingBean(value={EasyApiAutoConfiguration.class})
public abstract class AbstractConfigurationCreator
implements ConfigurationCreator,
ApplicationContextAware,
InitializingBean {
    private static ApplicationContext appContext;

    public abstract AllConfiguration replenish(AllConfiguration var1);

    @Override
    public AllConfiguration getConfiguration() {
        AllConfiguration configuration = new AllConfiguration();
        configuration.setConfiguration(new EasyApiBaseConfiguration());
        configuration.setUserConfiguration(new EasyApiUserConfiguration());
        configuration.setDataConfiguration(new EasyApiDataConfiguration());
        configuration = this.replenish(configuration);
        return configuration;
    }

    protected boolean runNow() {
        return true;
    }

    public void afterPropertiesSet() {
        if (this.runNow()) {
            EasyapiRun run = new EasyapiRun(this.getConfiguration(), appContext);
            run.run();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        appContext = applicationContext;
    }
}

