/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AnnotationUtil {
    public static Annotation getByAnnotationName(String name, Annotation[] annotations) {
        if (annotations == null || annotations.length == 0 || name == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            String canonicalName = annotation.annotationType().getCanonicalName();
            if (!canonicalName.equals(name)) continue;
            return annotation;
        }
        return null;
    }

    public static Object getAnnotationValue(Annotation annotation, String key) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
        try {
            Field field = invocationHandler.getClass().getDeclaredField("memberValues");
            field.setAccessible(true);
            Map memberValues = (Map)field.get(invocationHandler);
            if (memberValues == null || memberValues.isEmpty()) {
                return null;
            }
            field.setAccessible(false);
            return memberValues.get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Annotation getAssignableFromAnnotation(Annotation source, Class target) {
        ArrayList<Annotation> exsit = new ArrayList<Annotation>();
        AnnotationUtil.isAssignableFromAnnotation(source, target, exsit);
        if (exsit.size() > 0) {
            return (Annotation)exsit.get(0);
        }
        return null;
    }

    public static boolean isAssignableFromAnnotation(Annotation source, Class target) {
        ArrayList<Annotation> exsit = new ArrayList<Annotation>();
        AnnotationUtil.isAssignableFromAnnotation(source, target, exsit);
        return exsit.size() > 0;
    }

    private static void isAssignableFromAnnotation(Annotation source, Class target, List<Annotation> exsit) {
        Annotation[] ans;
        if (source instanceof Target || source instanceof Documented || source instanceof Retention) {
            return;
        }
        if (source.annotationType().isAssignableFrom(target)) {
            exsit.add(source);
        }
        if ((ans = source.annotationType().getAnnotations()).length == 0) {
            return;
        }
        for (Annotation an : ans) {
            AnnotationUtil.isAssignableFromAnnotation(an, target, exsit);
        }
    }
}

