/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.parameterized;

import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.util.ObjectUtil;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GenericTypeUtil {
    public static boolean isArray(Type type) {
        if (type == null) {
            return false;
        }
        if (type instanceof GenericArrayType) {
            return true;
        }
        if (Class.class.isAssignableFrom(type.getClass())) {
            Class typeClass = (Class)type;
            return typeClass.isArray() || Collection.class.isAssignableFrom(typeClass);
        }
        Class ownerClass = GenericTypeUtil.getOwnerClass(type);
        return ownerClass.isArray() || Collection.class.isAssignableFrom(ownerClass);
    }

    public static Class getArrayGenericClass(Type type) {
        Class typeClass;
        if (!GenericTypeUtil.isArray(type)) {
            return type.getClass();
        }
        if (GenericTypeUtil.isGeneric(type)) {
            GenericTypeBind binds = GenericTypeUtil.getGenericTypes(type);
            if (binds.size() > 1) {
                return type.getClass();
            }
            Type bindType = binds.get(0);
            if (GenericTypeUtil.isGeneric(bindType)) {
                return type.getClass();
            }
            typeClass = (Class)bindType;
        } else {
            typeClass = ((Class)type).getComponentType();
            if (typeClass == null) {
                return Object.class;
            }
        }
        return typeClass;
    }

    public static boolean isBaseArray(Type type) {
        return ObjectUtil.isBaseClass(GenericTypeUtil.getArrayGenericClass(type));
    }

    public static boolean isGeneric(Type type) {
        if (type == null) {
            return false;
        }
        if (type instanceof ParameterizedType) {
            return true;
        }
        if (type instanceof GenericArrayType) {
            return true;
        }
        if (type instanceof TypeVariable) {
            return true;
        }
        return type instanceof WildcardType;
    }

    public static Class getOwnerClass(Type type) {
        ArrayList<Class> ownerClass = new ArrayList<Class>();
        GenericTypeUtil.getOwnerClass(type, ownerClass);
        if (ownerClass.size() > 0) {
            return (Class)ownerClass.get(0);
        }
        return null;
    }

    private static void getOwnerClass(Type type, List<Class> ownerClass) {
        Type[] bounds;
        Type[] upperBounds;
        Type ownerType;
        if (type == null) {
            return;
        }
        if (!GenericTypeUtil.isGeneric(type) && type instanceof Class) {
            Class owner = (Class)type;
            if (owner.isArray()) {
                ownerClass.add(owner.getComponentType());
            } else {
                ownerClass.add((Class)type);
            }
            return;
        }
        if (type instanceof ParameterizedType) {
            ownerType = ((ParameterizedType)type).getRawType();
            GenericTypeUtil.getOwnerClass(ownerType, ownerClass);
        }
        if (type instanceof GenericArrayType) {
            ownerType = ((GenericArrayType)type).getGenericComponentType();
            GenericTypeUtil.getOwnerClass(ownerType, ownerClass);
        }
        if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()) != null && upperBounds.length > 0) {
            GenericTypeUtil.getOwnerClass(upperBounds[0], ownerClass);
        }
        if (type instanceof TypeVariable && (bounds = ((TypeVariable)type).getBounds()) != null && bounds.length > 0) {
            GenericTypeUtil.getOwnerClass(bounds[0], ownerClass);
        }
    }

    public static Type getGenericTypes(Type type, int index) {
        GenericTypeBind binds = GenericTypeUtil.getGenericTypes(type);
        return binds.get(index);
    }

    public static GenericTypeBind getGenericTypes(Type type) {
        GenericTypeBind bind = new GenericTypeBind();
        GenericTypeUtil.getGenericTypes(type, bind);
        return bind;
    }

    private static void getGenericTypes(Type type, GenericTypeBind bind) {
        if (type == null) {
            return;
        }
        if (!GenericTypeUtil.isGeneric(type)) {
            return;
        }
        if (type instanceof ParameterizedType) {
            Type[] arguments = ((ParameterizedType)type).getActualTypeArguments();
            Class rawType = (Class)((ParameterizedType)type).getRawType();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                bind.bind(typeParameters[i].getTypeName(), arguments[i]);
            }
            return;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type genericType = arrayType.getGenericComponentType();
            GenericTypeUtil.getGenericTypes(genericType, bind);
        }
        if (type instanceof WildcardType) {
            Type[] bounds = ((WildcardType)type).getLowerBounds();
            if (bounds.length == 0) {
                bounds = ((WildcardType)type).getUpperBounds();
            }
            if (bounds.length == 0) {
                bind.bind(type.getTypeName(), type);
                return;
            }
            GenericTypeUtil.getGenericTypes(bounds[0], bind);
        }
        if (type instanceof TypeVariable) {
            Type[] arguments;
            for (Type argument : arguments = ((TypeVariable)type).getBounds()) {
                GenericTypeUtil.getGenericTypes(argument, bind);
            }
        }
    }
}

