/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.logic.condition.ConstraintEnums;
import cn.easyutil.easyapi.util.AnnotationUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.validation.Constraint;

public class CreatorCommonMethod {
    public static List<String> readConditons(Annotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> conditons = new ArrayList<String>();
        for (Annotation annotation : annotations) {
            if (annotation instanceof ApidocComment) {
                ApidocComment an = (ApidocComment)annotation;
                String[] conditions = an.conditions();
                if (conditions.length == 0) {
                    return conditons;
                }
                return Arrays.asList(conditions);
            }
            if (!AnnotationUtil.isAssignableFromAnnotation(annotation, Constraint.class)) continue;
            conditons.add(ConstraintEnums.getElString(annotation));
        }
        return conditons;
    }

    public static String mockTemplate(Annotation[] annotations) {
        Object example;
        if (annotations == null || annotations.length == 0) {
            return "";
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof ApidocComment)) continue;
            ApidocComment api = (ApidocComment)annotation;
            return api.mockValue();
        }
        Annotation an = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiModelProperty", annotations);
        if (an != null && !StringUtil.isEmpty(example = AnnotationUtil.getAnnotationValue(an, "example"))) {
            return example.toString();
        }
        return "";
    }

    public static File getClassFile(Class clazz, String projectBasePath) {
        String path = clazz.getCanonicalName().replace(".", File.separator) + ".java";
        return new File(projectBasePath + path);
    }
}

