/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.javadoc.util;

import cn.easyutil.easyapi.javadoc.reader.ClassComment;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.javadoc.util.CommentStringUtil;
import cn.easyutil.easyapi.javadoc.util.CommentTypeUtil;
import cn.easyutil.easyapi.javadoc.util.MapGetMethodsPreEnum;
import cn.easyutil.easyapi.javadoc.util.MapKeyVal;
import cn.easyutil.easyapi.javadoc.util.MapPutMethodsPreEnum;
import cn.easyutil.easyapi.logic.creator.MethodParam;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class UncertainParamParser {
    private MethodComment methodComment;
    private ClassComment classComment;
    private Method method;
    private Class<?> clazz;

    private UncertainParamParser() {
    }

    public static UncertainParamParser builder(Class<?> clazz, Method method, ClassComment classComment, MethodComment methodComment) {
        UncertainParamParser parser = new UncertainParamParser();
        parser.clazz = clazz;
        parser.method = method;
        parser.classComment = classComment;
        parser.methodComment = methodComment;
        if (parser.classComment == null) {
            parser.classComment = new ClassComment();
        }
        if (parser.methodComment == null) {
            parser.methodComment = new MethodComment();
        }
        if (CollectionUtils.isEmpty(parser.classComment.getLines())) {
            parser.classComment.setLines(Collections.emptyList());
        }
        if (CollectionUtils.isEmpty(parser.methodComment.getLines())) {
            parser.methodComment.setLines(Collections.emptyList());
        }
        return parser;
    }

    public MethodParam parseRequestObj(String paramName) {
        Class<?> parseType = null;
        String variableName = null;
        for (String line : this.methodComment.getLines()) {
            if (!CommentStringUtil.isAssignLine(paramName, line)) continue;
            MapKeyVal<String> assign = CommentStringUtil.getAssign(line.split("=")[0]);
            Class<?> aClass = CommentTypeUtil.findQuoteClass(assign.getKey(), this.methodComment.getLines(), this.classComment.getLines(), this.clazz);
            if (aClass == null) {
                return null;
            }
            parseType = aClass;
            variableName = assign.getVal();
            break;
        }
        if (parseType == null) {
            return null;
        }
        MethodParam param = new MethodParam();
        param.setParamName(paramName);
        param.setParamType(parseType);
        if (!Map.class.isAssignableFrom(parseType)) {
            return param;
        }
        List<MethodParam> children = this.getMapGetValByVariableName(variableName);
        param.setChildren(children);
        return param;
    }

    public List<MethodParam> getMapPutValByVariableName(String mapVariableName) {
        ArrayList<MethodParam> result = new ArrayList<MethodParam>();
        for (String line : this.methodComment.getLines()) {
            Class<?> aClass;
            MapPutMethodsPreEnum preEnum = MapPutMethodsPreEnum.hasKeyword(mapVariableName, null, line);
            if (preEnum == null) continue;
            String params = line.substring(line.indexOf(preEnum.getKeyword()) + preEnum.getKeyword().length());
            String[] split = (params = params.substring(0, params.lastIndexOf(")")).trim()).split(",");
            if (split.length <= 1) continue;
            String splitKey = params.substring(0, params.indexOf(","));
            String splitVal = params.substring(params.indexOf(",") + 1);
            String key = CommentTypeUtil.getMapKeyName(splitKey, this.clazz, this.methodComment.getLines(), this.classComment.getLines());
            if (StringUtil.isEmpty(key) || (aClass = CommentTypeUtil.findQuoteClass(splitVal, this.methodComment.getLines(), this.classComment.getLines(), this.clazz)) == null) continue;
            MethodParam param = new MethodParam();
            param.setParamName(key);
            param.setParamType(aClass);
            result.add(param);
        }
        return result;
    }

    public List<MethodParam> getMapGetValByVariableName(String mapVariableName) {
        ArrayList<MethodParam> result = new ArrayList<MethodParam>();
        String variableName = null;
        for (String line : this.methodComment.getLines()) {
            MapGetMethodsPreEnum varEnum;
            if (CommentStringUtil.isAssignLine(mapVariableName, line)) {
                MapKeyVal<String> assign = CommentStringUtil.getAssign(line);
                variableName = assign.getVal();
            }
            String searchKey = null;
            Class<?> val = null;
            MapGetMethodsPreEnum preEnum = MapGetMethodsPreEnum.hasKeyword(mapVariableName, null, line);
            if (preEnum != null) {
                searchKey = mapVariableName + preEnum.getKeyword();
                val = preEnum.getClazz();
            }
            if (variableName != null && (varEnum = MapGetMethodsPreEnum.hasKeyword(variableName, null, line)) != null) {
                searchKey = variableName + varEnum.getKeyword();
                val = varEnum.getClazz();
            }
            if (searchKey == null) continue;
            if (val == null) {
                if (!line.contains("=")) continue;
                MapKeyVal<String> assign = CommentStringUtil.getAssign(line.split("=")[0]);
                val = CommentTypeUtil.findQuoteClass(assign.getKey(), this.methodComment.getLines(), this.classComment.getLines(), this.clazz);
            }
            if (val == null) continue;
            String params = line.substring(line.indexOf(searchKey) + searchKey.length());
            String key = CommentTypeUtil.getMapKeyName(params = params.substring(0, params.lastIndexOf(")")).trim(), this.clazz, this.methodComment.getLines(), this.classComment.getLines());
            if (StringUtil.isEmpty(key)) continue;
            MethodParam param = new MethodParam();
            param.setParamName(key);
            param.setParamType(val);
            result.add(param);
        }
        return result;
    }

    public MethodParam parseRequestMap(String paramName) {
        List<MethodParam> list = this.getMapGetValByVariableName(paramName);
        MethodParam param = new MethodParam();
        param.setParamName(paramName);
        param.setParamType((Type)((Object)Map.class));
        param.setChildren(list);
        return param;
    }

    public MethodParam parseRequestMapField(String paramName, String fieldName) {
        String start = fieldName.substring(0, 1).toUpperCase();
        return this.parseRequestMap(paramName + ".get" + start + fieldName.substring(1) + "()");
    }

    public MethodParam parseRequestObjField(String paramName, String fieldName) {
        String start = fieldName.substring(0, 1).toUpperCase();
        return this.parseRequestObj(paramName + ".get" + start + fieldName.substring(1) + "()");
    }

    public MethodParam parseResponseObj() {
        List<String> lines = JsonUtil.jsonToList(JsonUtil.beanToJson(this.methodComment.getLines()), String.class);
        Collections.reverse(lines);
        String returnVariableName = CommentStringUtil.getReturnVariable(lines);
        if (returnVariableName == null) {
            return null;
        }
        Class<?> aClass = CommentTypeUtil.findVariableClassByReflection(returnVariableName, this.clazz, this.method);
        if (aClass == null && (aClass = CommentTypeUtil.findQuoteClass(returnVariableName, this.methodComment.getLines(), this.classComment.getLines(), this.clazz)) == null) {
            return null;
        }
        MethodParam param = new MethodParam();
        param.setParamName(returnVariableName);
        param.setParamType(aClass);
        if (!Map.class.isAssignableFrom(aClass)) {
            return param;
        }
        List<MethodParam> children = this.getMapPutValByVariableName(returnVariableName);
        param.setChildren(children);
        return param;
    }

    public MethodParam parseResponseMap() {
        return this.parseResponseObj();
    }

    public MethodParam parseResponseMapField(String fieldName) {
        return this.parseResponseObjField(fieldName);
    }

    public MethodParam parseResponseObjField(String fieldName) {
        List<String> lines = JsonUtil.jsonToList(JsonUtil.beanToJson(this.methodComment.getLines()), String.class);
        Collections.reverse(lines);
        String returnVariable = CommentStringUtil.getReturnVariable(lines);
        if (StringUtil.isEmpty(returnVariable)) {
            return null;
        }
        String params = null;
        for (String line : lines) {
            String keyword = returnVariable.toUpperCase() + ".SET" + fieldName.toUpperCase() + "(";
            if (!line.toUpperCase().contains(keyword)) continue;
            int index = line.toUpperCase().indexOf(keyword) + keyword.length();
            params = line.substring(index);
            params = params.substring(0, params.indexOf(")"));
            break;
        }
        if (params == null) {
            return null;
        }
        Class<?> aClass = CommentTypeUtil.findVariableClassByReflection(params, this.clazz, this.method);
        if (aClass == null) {
            aClass = CommentTypeUtil.findQuoteClass(params, this.methodComment.getLines(), this.classComment.getLines(), this.clazz);
        }
        if (aClass == null) {
            return null;
        }
        MethodParam param = new MethodParam();
        param.setParamName(fieldName);
        param.setParamType(aClass);
        if (!Map.class.isAssignableFrom(aClass)) {
            return param;
        }
        List<MethodParam> children = this.getMapPutValByVariableName(params);
        param.setChildren(children);
        return param;
    }
}

