/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.entity.common;

import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public enum JavaType {
    Long(new Class[]{Long.class, java.lang.Long.TYPE}, "\u6574\u6570", 1),
    Integer(new Class[]{Integer.class, java.lang.Integer.TYPE}, "\u6574\u6570", 1),
    Double(new Class[]{Double.class, java.lang.Double.TYPE}, "\u6570\u5b57", 2),
    Float(new Class[]{Float.class, java.lang.Float.TYPE}, "\u6570\u5b57", 2),
    Byte(new Class[]{Byte.class, java.lang.Byte.TYPE}, "\u6574\u6570", 1),
    Boolean(new Class[]{Boolean.class, java.lang.Boolean.TYPE}, "\u5e03\u5c14", 3),
    Short(new Class[]{Short.class, java.lang.Short.TYPE}, "\u6574\u6570", 1),
    String(new Class[]{String.class}, "\u5b57\u7b26", 4),
    Character(new Class[]{Character.class, java.lang.Character.TYPE}, "\u5b57\u7b26", 4),
    Array(new Class[]{Collection.class}, "\u57fa\u672c\u6570\u7ec4", 5),
    ArrayObject(new Class[]{Collection.class}, "\u5bf9\u8c61\u6570\u7ec4", 9),
    File(new Class[]{MultipartFile.class}, "\u6587\u4ef6", 7),
    Map(new Class[]{Map.class}, "map", 8),
    Object(null, "\u5bf9\u8c61", 6);

    private Class[] javaClass;
    private String remark;
    private Integer type;
    private static final List<JavaType> baseType;

    private JavaType(Class[] javaClass, String remark, Integer type) {
        this.javaClass = javaClass;
        this.remark = remark;
        this.type = type;
    }

    public static boolean isBaseType(JavaType type) {
        return baseType.contains((Object)type);
    }

    public static boolean isBaseType(Integer type) {
        return JavaType.isBaseType(JavaType.getType(type));
    }

    public static JavaType getJavaTypeByClass(Class clazz) {
        if (clazz == null) {
            return Object;
        }
        for (JavaType javaType : JavaType.values()) {
            Class[] javaClass = javaType.getJavaClass();
            if (javaClass == null || javaClass.length == 0) continue;
            for (Class aClass : javaClass) {
                if (!aClass.isAssignableFrom(clazz)) continue;
                return javaType;
            }
        }
        return Object;
    }

    public static JavaType getJavaTypeByType(Type type) {
        if (!GenericTypeUtil.isArray(type) && !GenericTypeUtil.isGeneric(type)) {
            return JavaType.getJavaTypeByClass((Class)type);
        }
        if (GenericTypeUtil.isArray(type)) {
            Class arrayClass = GenericTypeUtil.getArrayGenericClass(type);
            if (JavaType.isBaseType(JavaType.getJavaTypeByClass(arrayClass))) {
                return Array;
            }
            return ArrayObject;
        }
        Class ownerClass = GenericTypeUtil.getOwnerClass(type);
        return JavaType.getJavaTypeByClass(ownerClass);
    }

    public static JavaType getType(Integer type) {
        JavaType[] values;
        if (StringUtil.isEmpty(type)) {
            return Map;
        }
        for (JavaType value : values = JavaType.values()) {
            if (value.getType() != type) continue;
            return value;
        }
        return Map;
    }

    public boolean alikeClass(Class clazz) {
        Integer type = this.getType();
        JavaType[] values = JavaType.values();
        HashSet<Class> set = new HashSet<Class>();
        for (JavaType value : values) {
            if (!value.getType().equals(type)) continue;
            set.addAll(Arrays.asList(value.getJavaClass()));
        }
        for (Class aClass : set) {
            if (!aClass.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public Class[] getJavaClass() {
        return this.javaClass;
    }

    public String getRemark() {
        return this.remark;
    }

    public Integer getType() {
        return this.type;
    }

    static {
        baseType = Arrays.asList(Long, Integer, Double, Float, Byte, Boolean, Short, Character, String, File, Map);
    }
}

