/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi;

import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiBaseConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiDataConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiGlobalRequestConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiGlobalResponseConfiguration;
import cn.easyutil.easyapi.content.AuthModuleButtonsEnum;
import cn.easyutil.easyapi.content.DBTableClassify;
import cn.easyutil.easyapi.content.DBTables;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.auth.AuthModule;
import cn.easyutil.easyapi.entity.db.auth.DBDictEntity;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleAuthEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHostEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.handler.operator.provide.BeanReaderProvider;
import cn.easyutil.easyapi.handler.operator.provide.ControllerReaderProvider;
import cn.easyutil.easyapi.handler.operator.provide.InterfaceReaderProvider;
import cn.easyutil.easyapi.handler.operator.provide.MockReaderProvider;
import cn.easyutil.easyapi.handler.operator.provide.RequestReaderProvider;
import cn.easyutil.easyapi.handler.operator.provide.ResponseReaderProvider;
import cn.easyutil.easyapi.hook.ApiRunAround;
import cn.easyutil.easyapi.hook.DefaultApiRunAround;
import cn.easyutil.easyapi.interview.dto.OpenSyncDto;
import cn.easyutil.easyapi.logic.creator.MethodParam;
import cn.easyutil.easyapi.logic.run.DocCreate;
import cn.easyutil.easyapi.mybatis.MybatisUtil;
import cn.easyutil.easyapi.mybatis.SqlExecMapper;
import cn.easyutil.easyapi.mybatis.service.ControllerService;
import cn.easyutil.easyapi.mybatis.service.DictService;
import cn.easyutil.easyapi.mybatis.service.HostService;
import cn.easyutil.easyapi.mybatis.service.InterfaceParamService;
import cn.easyutil.easyapi.mybatis.service.InterfaceService;
import cn.easyutil.easyapi.mybatis.service.ModuleService;
import cn.easyutil.easyapi.mybatis.service.ProjectService;
import cn.easyutil.easyapi.mybatis.service.RoleAuthService;
import cn.easyutil.easyapi.mybatis.service.RoleProjectService;
import cn.easyutil.easyapi.mybatis.service.RoleService;
import cn.easyutil.easyapi.mybatis.service.SimpleUnitService;
import cn.easyutil.easyapi.mybatis.service.UserService;
import cn.easyutil.easyapi.mybatis.service.UserTemporaryAuthService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;

public class EasyapiRun {
    private ProjectService projectService;
    private UserService userService;
    private DictService dictService;
    private UserTemporaryAuthService userTemporaryAuthService;
    private HostService hostService;
    private ModuleService moduleService;
    private RoleService roleService;
    private RoleAuthService roleAuthService;
    private RoleProjectService roleProjectService;
    private ControllerService controllerService;
    private InterfaceService interfaceService;
    private InterfaceParamService interfaceParamService;
    private SimpleUnitService simpleUnitService;
    private final AllConfiguration all;
    private final ApplicationContext appContext;
    private ApiRunAround apiRunAround = new DefaultApiRunAround();

    public EasyapiRun(AllConfiguration all, ApplicationContext appContext) {
        this.all = all;
        this.appContext = appContext;
        AssertUtil.isNull((Object)all, "\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNull((Object)appContext, "spring\u73af\u5883\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void setApiRunAround(ApiRunAround apiRunAround) {
        this.apiRunAround = apiRunAround;
    }

    public void run() {
        EasyApiBaseConfiguration configuration = this.all.getConfiguration();
        configuration.getUnique();
        if (!configuration.isEnable()) {
            return;
        }
        try {
            this.initBase(this.all);
            this.initDataSource(this.all);
            this.initService();
            this.apiRunAround.dataSourceInitialized();
            this.createDB();
            this.apiRunAround.dbCleared();
            DBProjectEntity project = this.initProject();
            this.apiRunAround.projectInitialized(project);
            this.clearDB();
            this.apiRunAround.dbCleared();
            this.apiRunAround.beforeCreateApi();
            DocCreate instance = DocCreate.getInstance(this.all, this.appContext);
            if (configuration.isRescan()) {
                instance.createApi();
            }
            this.apiRunAround.apiCreated();
        }
        catch (Exception e) {
            throw new RuntimeException("\u63a5\u53e3\u6587\u6863\u751f\u6210\u5931\u8d25", e);
        }
    }

    private void initService() {
        this.projectService = new ProjectService();
        this.userService = new UserService();
        this.dictService = new DictService();
        this.userTemporaryAuthService = new UserTemporaryAuthService();
        this.hostService = new HostService();
        this.moduleService = new ModuleService();
        this.roleService = new RoleService();
        this.roleAuthService = new RoleAuthService();
        this.roleProjectService = new RoleProjectService();
        this.controllerService = new ControllerService();
        this.interfaceService = new InterfaceService();
        this.interfaceParamService = new InterfaceParamService();
        this.simpleUnitService = new SimpleUnitService();
    }

    private void initBase(AllConfiguration all) {
        EasyApiGlobalRequestConfiguration globalRequest;
        ProjectContext.allConfiguration = all;
        Set<String> projectSourcePaths = all.getConfiguration().getProjectSourcePaths();
        String filePost = File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
        if (projectSourcePaths.isEmpty()) {
            try {
                String path = new File("").getCanonicalPath();
                projectSourcePaths.add(path + filePost);
            }
            catch (IOException e) {
                throw new ApidocException(e);
            }
        }
        Iterator<String> iterator = projectSourcePaths.iterator();
        HashSet<String> copyPaths = new HashSet<String>();
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (!next.endsWith(File.separator)) {
                next = next + File.separator;
            }
            if (!next.endsWith(filePost)) {
                next = next + filePost;
            }
            copyPaths.add(next);
        }
        projectSourcePaths = copyPaths;
        ProjectContext.projectBasePath = projectSourcePaths;
        ProjectContext.controllerOperator = new ControllerReaderProvider();
        ProjectContext.interfaceOperator = new InterfaceReaderProvider();
        ProjectContext.beanOperator = new BeanReaderProvider();
        ProjectContext.mockTemplateOperator = new MockReaderProvider();
        ProjectContext.requestOperator = new RequestReaderProvider();
        ProjectContext.responseOperator = new ResponseReaderProvider();
        EasyApiGlobalResponseConfiguration globalResponse = all.getGlobalResponseConfiguration();
        if (globalResponse.isEnable() && globalResponse.getReturnType() != null && !StringUtil.isEmpty(globalResponse.getFieldName())) {
            ProjectContext.globalResponseParams = this.getGlobalParams(globalResponse.getReturnType(), globalResponse.getIgnoreFields());
        }
        if ((globalRequest = all.getGlobalRequestConfiguration()).isEnable() && globalRequest.getRequestType() != null && !StringUtil.isEmpty(globalRequest.getFieldName())) {
            ProjectContext.globalRequestParams = this.getGlobalParams(globalRequest.getRequestType(), globalRequest.getIgnoreFields());
        }
    }

    private List<MethodParam> getGlobalParams(Class<?> type, Set<String> ignoreFields) {
        Field[] fields;
        ArrayList<MethodParam> globalParams = new ArrayList<MethodParam>();
        for (Field field : fields = type.getDeclaredFields()) {
            boolean match = ignoreFields.stream().anyMatch(ignore -> ignore.equals(field.getName()));
            if (match) continue;
            MethodParam param = new MethodParam();
            param.setParamType(field.getGenericType());
            param.setParamName(field.getName());
            globalParams.add(param);
        }
        return globalParams;
    }

    private void initDataSource(AllConfiguration all) {
        EasyApiDataConfiguration dataConfiguration = all.getDataConfiguration();
        if (StringUtil.isEmpty(dataConfiguration.getDriverClassName())) {
            dataConfiguration.setDriverClassName("org.h2.Driver");
        }
        if (StringUtil.isEmpty(dataConfiguration.getUrl())) {
            String dbFilePath = all.getDataConfiguration().getDbFilePath();
            if (dbFilePath.endsWith(File.separator)) {
                dbFilePath = dbFilePath.substring(0, dbFilePath.length() - 1);
            }
            dataConfiguration.setUrl("jdbc:h2:" + dbFilePath + "-easyapi;AUTO_SERVER=TRUE");
        }
        if (StringUtil.isEmpty(dataConfiguration.getUserName())) {
            dataConfiguration.setUserName("easyapi");
        }
        if (StringUtil.isEmpty(dataConfiguration.getPassword())) {
            dataConfiguration.setPassword("123456");
        }
        ArrayList<DBTables> mappersClasses = new ArrayList<DBTables>(Arrays.asList(DBTables.values()));
        mappersClasses.removeIf(table -> table.getMapper() == null);
        List<Class> collect = mappersClasses.stream().map(DBTables::getMapper).collect(Collectors.toList());
        Class[] mappers = new Class[collect.size()];
        collect.toArray(mappers);
        if (dataConfiguration.getDataSource() != null) {
            MybatisUtil.init(dataConfiguration.getDataSource(), all.getConfiguration().isShowSql(), mappers);
        } else {
            DataSource dataSource = this.dataSource(dataConfiguration.getUrl(), dataConfiguration.getDriverClassName(), dataConfiguration.getUserName(), dataConfiguration.getPassword());
            MybatisUtil.init(dataSource, all.getConfiguration().isShowSql(), mappers);
        }
    }

    private void createDB() {
        SqlExecMapper mapper = MybatisUtil.getMapper(SqlExecMapper.class);
        for (DBTables table : DBTables.values()) {
            mapper.execUpdate(table.tableDDL());
            table.replenishField();
        }
    }

    private void clearDB() {
        EasyApiBaseConfiguration configuration = this.all.getConfiguration();
        SqlExecMapper mapper = MybatisUtil.getMapper(SqlExecMapper.class);
        if (configuration.isDropAll() && ProjectContext.currentProject.getDefaultStatus() == 1) {
            for (DBTables table : DBTables.values()) {
                mapper.execUpdate(table.dropSql());
            }
            this.createDB();
            this.initProject();
        }
        if (configuration.isDropUsers() && ProjectContext.currentProject.getDefaultStatus() == 1) {
            for (DBTables table : DBTables.getByClassify(DBTableClassify.user)) {
                mapper.execUpdate(table.clearSql());
            }
            DBModuleEntity module = new DBModuleEntity();
            module.setProjectId(ProjectContext.currentProjectId);
            module.setId(ProjectContext.currentModuleId);
            this.addDefaultUsers(module);
        }
        if (configuration.isDropGlobalSetting() && ProjectContext.currentProject.getDefaultStatus() == 1) {
            for (DBTables table : DBTables.getByClassify(DBTableClassify.global)) {
                mapper.execUpdate(table.clearSql());
            }
        }
        if (configuration.isDropDoc()) {
            for (DBTables table : DBTables.getByClassify(DBTableClassify.doc)) {
                if (ProjectContext.currentProject.getDefaultStatus() == 1) {
                    mapper.execUpdate(table.clearSql());
                    continue;
                }
                mapper.execUpdate("delete from " + table.getTableName() + " where PROJECT_ID=" + ProjectContext.currentProject.getId());
            }
        }
    }

    private DataSource dataSource(String url, String driverClassName, String username, String password) {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setUrl(url);
        druidDataSource.setUsername(username);
        druidDataSource.setPassword(password);
        druidDataSource.setDriverClassName(driverClassName);
        druidDataSource.setInitialSize(0);
        druidDataSource.setMaxActive(100);
        druidDataSource.setMaxWait(10000L);
        druidDataSource.setMinIdle(20);
        druidDataSource.setValidationQuery("Select  'x' from DUAL");
        druidDataSource.setTestOnBorrow(false);
        druidDataSource.setTestOnReturn(false);
        druidDataSource.setTestWhileIdle(true);
        druidDataSource.setTimeBetweenEvictionRunsMillis(60000L);
        druidDataSource.setMinEvictableIdleTimeMillis(25200000L);
        druidDataSource.setRemoveAbandoned(true);
        druidDataSource.setRemoveAbandonedTimeout(1800);
        druidDataSource.setLogAbandoned(true);
        return druidDataSource;
    }

    private DBProjectEntity initProject() {
        DBProjectEntity query = (DBProjectEntity)this.projectService.getOne((Wrapper)Wrappers.lambdaQuery(DBProjectEntity.class).eq(DBProjectEntity::getProjectUnique, (Object)this.all.getConfiguration().getUnique()));
        if (query != null) {
            ProjectContext.currentProjectId = query.getId();
            ProjectContext.currentProjectName = query.getProjectName();
            ProjectContext.currentProject = query;
            return query;
        }
        int count = this.projectService.count();
        DBProjectEntity project = this.addDefaultProject(count > 0 ? 0 : 1);
        DBModuleEntity module = this.addDefaultModule(project);
        DBUserEntity admin = (DBUserEntity)this.userService.getOne((Wrapper)Wrappers.lambdaQuery(DBUserEntity.class).eq(DBUserEntity::getAccount, (Object)"admin"));
        if (admin == null) {
            this.addDefaultUsers(module);
        } else {
            admin.setAccount(this.all.getUserConfiguration().getAccount());
            admin.setPassword(StringUtil.toMD5(this.all.getUserConfiguration().getPassword()));
            this.userService.updateById(admin);
        }
        ProjectContext.currentProjectId = project.getId();
        ProjectContext.currentModuleId = module.getId();
        ProjectContext.currentProjectName = project.getProjectName();
        ProjectContext.currentModuleName = module.getName();
        ProjectContext.currentProject = project;
        DBDictEntity syncEnable = new DBDictEntity();
        syncEnable.setDictKey(DBDictEntity.syncStatusKey());
        syncEnable = (DBDictEntity)this.dictService.getOne((Wrapper)Wrappers.lambdaQuery((Object)syncEnable), false);
        if (syncEnable == null) {
            syncEnable = new DBDictEntity();
            syncEnable.setDictKey(DBDictEntity.syncStatusKey());
            syncEnable.setDictVal("0");
            this.dictService.save(syncEnable);
        }
        DBDictEntity syncInterfaces = new DBDictEntity();
        syncInterfaces.setDictKey(DBDictEntity.syncInterfacesKey());
        syncInterfaces = (DBDictEntity)this.dictService.getOne((Wrapper)Wrappers.lambdaQuery((Object)syncInterfaces), false);
        if (syncInterfaces == null) {
            syncInterfaces = new DBDictEntity();
            syncInterfaces.setDictKey(DBDictEntity.syncInterfacesKey());
            syncInterfaces.setDictVal("[]");
            this.dictService.save(syncInterfaces);
        }
        DBDictEntity syncInfo = new DBDictEntity();
        syncInfo.setDictKey(DBDictEntity.syncInfoKey());
        syncInfo = (DBDictEntity)this.dictService.getOne((Wrapper)Wrappers.lambdaQuery((Object)syncInfo), false);
        if (syncInfo == null) {
            syncInfo = new DBDictEntity();
            syncInfo.setDictKey(DBDictEntity.syncInfoKey());
            syncInfo.setDictVal(JsonUtil.beanToJson(new OpenSyncDto()));
            this.dictService.save(syncInfo);
        }
        DBDictEntity syncSecret = new DBDictEntity();
        syncSecret.setDictKey(DBDictEntity.syncSecretKey());
        syncSecret = (DBDictEntity)this.dictService.getOne((Wrapper)Wrappers.lambdaQuery((Object)syncSecret), false);
        if (syncSecret == null) {
            syncSecret = new DBDictEntity();
            syncSecret.setDictKey(DBDictEntity.syncSecretKey());
            syncSecret.setDictVal(this.all.getConfiguration().getSyncSecret());
            this.dictService.save(syncSecret);
        }
        this.all.getConfiguration().setSyncSecret(syncSecret.getDictVal());
        this.all.getConfiguration().setUnique(project.getProjectUnique());
        return project;
    }

    private DBProjectEntity addDefaultProject(Integer defaultStatus) {
        DBProjectEntity project = new DBProjectEntity();
        project.setDefaultStatus(defaultStatus);
        project.setTitle(this.all.getConfiguration().getProjectName());
        project.setProjectName(this.all.getConfiguration().getProjectName());
        project.setProjectUnique(this.all.getConfiguration().getUnique());
        project.setAppSecret(this.all.getConfiguration().getSyncSecret());
        this.projectService.save(project);
        return project;
    }

    private void addDefaultUsers(DBModuleEntity module) {
        DBUserEntity user = new DBUserEntity();
        user.setAccount(this.all.getUserConfiguration().getAccount());
        user.setPassword(StringUtil.toMD5(this.all.getUserConfiguration().getPassword()));
        user.setDisable(0);
        user.setDescription("\u8d85\u7ea7\u7ba1\u7406\u5458");
        user.setNickName("\u8d85\u7ea7\u7ba1\u7406\u5458");
        user.setSuperAdminStatus(1);
        user.setRoleId(0L);
        user.setHidden(1);
        user.setProjectId(module.getProjectId());
        user.setCreateTime(System.currentTimeMillis());
        user.setUpdateTime(System.currentTimeMillis());
        this.userService.save(user);
        this.userTemporaryAuthService.binds(user, Stream.of(AuthModuleButtonsEnum.values()).map(AuthModuleButtonsEnum::getCode).collect(Collectors.toList()));
        DBUserEntity hiddenUser = new DBUserEntity();
        hiddenUser.setAccount("remote");
        hiddenUser.setPassword(StringUtil.toMD5("remote"));
        hiddenUser.setSuperAdminStatus(1);
        hiddenUser.setRoleId(0L);
        hiddenUser.setHidden(1);
        hiddenUser.setProjectId(module.getProjectId());
        hiddenUser.setCreateTime(System.currentTimeMillis());
        hiddenUser.setUpdateTime(System.currentTimeMillis());
        this.userService.save(hiddenUser);
        DBRoleEntity testRole = new DBRoleEntity();
        testRole.setRoleName("\u6d4b\u8bd5\u4eba\u5458");
        testRole.setDescription("\u4ec5\u63d0\u4f9b\u6d4b\u8bd5\u76f8\u5173\u7684\u6743\u9650");
        testRole.setSuperAdminStatus(0);
        testRole.setProjectId(module.getProjectId());
        testRole.setCreateTime(System.currentTimeMillis());
        testRole.setUpdateTime(System.currentTimeMillis());
        this.roleService.save(testRole);
        DBRoleProjectEntity roleProject = new DBRoleProjectEntity();
        roleProject.setRoleId(testRole.getId());
        roleProject.setProjectId(module.getProjectId());
        roleProject.setCreateTime(System.currentTimeMillis());
        roleProject.setUpdateTime(System.currentTimeMillis());
        this.roleProjectService.save(roleProject);
        List<Integer> defaultAuthCodes = AuthModule.getDefaultAuthCodes();
        ArrayList<DBRoleAuthEntity> auths = new ArrayList<DBRoleAuthEntity>();
        for (Integer code : defaultAuthCodes) {
            DBRoleAuthEntity entity = new DBRoleAuthEntity();
            entity.setRoleId(testRole.getId());
            entity.setAuthCode(code);
            entity.setModuleId(module.getId());
            entity.setProjectId(module.getProjectId());
            entity.setCreateTime(System.currentTimeMillis());
            entity.setUpdateTime(System.currentTimeMillis());
            auths.add(entity);
        }
        this.roleAuthService.saveBatch(auths);
        DBUserEntity test = new DBUserEntity();
        test.setAccount("test");
        test.setPassword(StringUtil.toMD5("test"));
        test.setSuperAdminStatus(0);
        test.setProjectId(module.getProjectId());
        test.setRoleId(testRole.getId());
        test.setNickName("\u6d4b\u8bd5\u8d26\u53f7");
        test.setDescription("\u6d4b\u8bd5\u4eba\u5458\u8d26\u53f7");
        test.setDisable(0);
        test.setBindProjectIds(module.getProjectId().toString());
        this.userService.save(test);
        this.userTemporaryAuthService.binds(test, Stream.of(AuthModuleButtonsEnum.values()).filter(item -> item.getDefaultStatus() == 1).map(AuthModuleButtonsEnum::getCode).collect(Collectors.toList()));
    }

    private DBModuleEntity addDefaultModule(DBProjectEntity project) {
        DBModuleEntity module = new DBModuleEntity();
        module.setProjectId(project.getId());
        module.setName("\u9ed8\u8ba4\u6a21\u5757");
        module.setDescription("\u521d\u59cb\u5316\u9879\u76ee\u6a21\u5757");
        module.setOutPackgeStatus(0);
        module.setDefaultStatus(project.getDefaultStatus());
        this.moduleService.save(module);
        if (project.getDefaultStatus() == 0) {
            return module;
        }
        DBModuleHostEntity mock = new DBModuleHostEntity();
        mock.setModuleId(module.getId());
        mock.setProjectId(project.getId());
        mock.setName("mock");
        mock.setDescription("mock\u8bf7\u6c42,\u8fd4\u56demock\u7ed3\u679c");
        mock.setDefaultStatus(project.getDefaultStatus());
        mock.setDisable(0);
        mock.setCanDelete(0);
        String port = this.appContext.getEnvironment().getProperty("server.port");
        port = port == null ? "8080" : port;
        mock.setHost("mock");
        this.hostService.save(mock);
        DBModuleHostEntity local = new DBModuleHostEntity();
        local.setProjectId(project.getId());
        local.setModuleId(module.getId());
        local.setName("\u672c\u5730\u73af\u5883");
        local.setDescription("\u672c\u673a\u73af\u5883");
        local.setDefaultStatus(0);
        local.setDisable(0);
        mock.setCanDelete(1);
        String address = "localhost";
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        local.setHost("http://" + address + ":" + port);
        this.hostService.save(local);
        return module;
    }
}

