package cn.easyutil.easyapi.util;

import cn.easyutil.easyapi.interview.JacksonBigLongTypeSerializer;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

/** JSON帮助类 */
public class JsonUtil {
	 private static ObjectMapper objectMapper = new ObjectMapper();
	 static {
		objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
		objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
		objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
		objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
		JavaTimeModule simpleModule = new JavaTimeModule();
		//设置Long类型转string
		simpleModule.addSerializer(Long.class, JacksonBigLongTypeSerializer.instance);
		//设置Long类型转string
		simpleModule.addSerializer(Long.TYPE, JacksonBigLongTypeSerializer.instance);
		objectMapper.registerModule(simpleModule);
	}

	/** 将JSON字符串转换为map */
	@SuppressWarnings("unchecked")
	public static Map<String, Object> jsonToMap(String json) {
		Map<String, Object> map = (Map<String, Object>) JSONObject.parse(json);
		return map;
	}
	/** 将obj转换成map */
	public static Map<String, Object> beanToMap(Object obj) {
		return jsonToMap(beanToJson(obj));
	}
	
	/** 将map转换成obj */
	public static <T>T mapToBean(Map<String, Object> map, Class<T> beanClass) {
//		return jsonToMap(objToJson(obj));
		return jsonToBean(beanToJson(map), beanClass);
	}
	
	/** 字符串转json */
	public static String beanToJson(Object obj) {
		return JSONObject.toJSONString(obj,SerializerFeature.DisableCircularReferenceDetect);
	}

	public static String toJackson(Object obj){
		try {
			return objectMapper.writeValueAsString(obj);
		} catch (JsonProcessingException e) {
			return beanToJson(obj);
		}
	}

	public static <T>T parse(Object obj,Class<T> clazz){
		return JsonUtil.jsonToBean(JsonUtil.beanToJson(obj),clazz);
	}
	
	/** 将json字符串转换为对象 */
	public static <T> T jsonToBean(String jsonStr, Class<T> beanClass) {
		return (T) JSONObject.parseObject(jsonStr, beanClass);
	}
	
	/** 将json字符串转换为列表 */
	public static <T> List<T> jsonToList(String jsonStr, Class<T> beanClass) {
		return (List<T>) JSONObject.parseArray(jsonStr, beanClass);
	}
	
	public static JSONObject JSONObject(){
		return new JSONObject();
	}
	
	public static JSONArray JSONArray(){
		return new JSONArray();
	}
	/** 测试JSON格式是否正常 */
	public static boolean isJson(String json) {
    	try {
    		JSONObject.parse(json);
			return true;
		} catch (Exception e) {
			return false;
		}
    }
}
