package cn.easyutil.easyapi.util;

import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class ApidocCommentUtil {

    public static String clearComment(String comment){
        if(StringUtil.isEmpty(comment)){
            return comment;
        }
        if(comment.contains("--|")){
            return comment.substring(0,comment.indexOf("--|"));
        }
        return comment;
    }

    public static boolean isMatchPath(String pattern,String path){
        PathMatcher matcher = new AntPathMatcher();
        return matcher.match(pattern,path);
    }

    public static String getCommentValue(String comment,String key){
        if(StringUtil.isEmpty(comment)){
            return null;
        }
        if(!comment.contains("--|")){
            return null;
        }
        if(StringUtil.isEmpty(key)){
            key = "";
        }
        String[] split = comment.substring(comment.indexOf("--|") + 3).split("\\|");
        for (String s : split) {
            if(StringUtil.isEmpty(key)){
                //没有key，默认找不带冒号的
                if(!s.contains(":")){
                   return s.trim().replace("?","*");
                }
                if(s.trim().startsWith("value:")){
                    return s.trim().substring(s.indexOf("value:")+6);
                }
            }
            if(s.trim().startsWith(key+":")){
                return s.trim().substring(s.indexOf(key+":")+key.length()+1).trim().replace("?","*");
            }
        }
        return null;
    }
}
