package cn.easyutil.easyapi.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 注解类
 */
public class AnnotationUtil {

    public static Annotation getByAnnotationName(String name,Annotation[] annotations){
        if(annotations==null || annotations.length==0 || name==null){
            return null;
        }
        for (Annotation annotation : annotations) {
            String canonicalName = annotation.annotationType().getCanonicalName();
            if(canonicalName.equals(name)){
                return annotation;
            }
        }
        return null;
    }

    /**
     * 获取注解的值
     * @param annotation    注解
     * @param key   注解属性(属性方法名)
     */
    public static Object getAnnotationValue(Annotation annotation, String key){
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
        try {
            Field field = invocationHandler.getClass().getDeclaredField("memberValues");
            field.setAccessible(true);
            Map<String, Object> memberValues = (Map<String, Object>) field.get(invocationHandler);
            if(memberValues==null || memberValues.isEmpty()){
                return null;
            }
            field.setAccessible(false);
            return memberValues.get(key);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 获取包含的另外一个注解
     * @param source    源注解
     * @param target    判断是否包含的注解
     */
    public static Annotation getAssignableFromAnnotation(Annotation source,Class target){
        List<Annotation> exsit = new ArrayList<>();
        isAssignableFromAnnotation(source,target,exsit);
        if(exsit.size() > 0){
            return exsit.get(0);
        }
        return null;
    }

    /**
     * 判断一个注解是否包含另外一个注解
     * @param source    源注解
     * @param target    判断是否包含的注解
     * @return  true:包含
     */
    public static boolean isAssignableFromAnnotation(Annotation source,Class target){
        List<Annotation> exsit = new ArrayList<>();
        isAssignableFromAnnotation(source,target,exsit);
        return exsit.size() > 0;
    }

    private static void isAssignableFromAnnotation(Annotation source,Class target, List<Annotation> exsit){
        if((source instanceof Target) || (source instanceof Documented) || (source instanceof Retention)){
            return ;
        }
        if(source.annotationType().isAssignableFrom(target)){
            exsit.add(source);
        }
        Annotation[] ans = source.annotationType().getAnnotations();
        if(ans.length == 0){
            return ;
        }
        for (Annotation an : ans) {
            isAssignableFromAnnotation(an,target,exsit);
        }
    }
}
