package cn.easyutil.easyapi.task;

import cn.easyutil.easyapi.entity.db.auth.DBDictEntity;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.interview.dto.OpenSyncDto;
import cn.easyutil.easyapi.interview.entity.ResponseBody;
import cn.easyutil.easyapi.interview.entity.UnifiedAccessDto;
import cn.easyutil.easyapi.mybatis.service.*;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import cn.easyutil.easyapi.util.http.*;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;

/**
 * 同步任务
 */
@Component
public class SyncTask {

    private static final ControllerService controllerService = new ControllerService();

    private static final InterfaceService interfaceService = new InterfaceService();

    private static final InterfaceParamService paramService = new InterfaceParamService();

    private static final ProjectService projectService = new ProjectService();

    private static final DictService dictService = new DictService();

    private static final Object lock = new Object();


    //开始执行任务
    public static void start(){
        synchronized (lock){
            lock.notifyAll();
        }
    }

    private static void threadWait(){
        //如果停止同步，则释放线程
        synchronized (lock){
            try {
                lock.wait();
            } catch (InterruptedException ignored) {}
        }
    }

    @PostConstruct
    private void doTask(){
        new Thread(()->{
            while (true){
                DBDictEntity status = dictService.getByKey(DBDictEntity.syncStatusKey());
                DBDictEntity info = dictService.getByKey(DBDictEntity.syncInfoKey());
                if(status==null || "0".equals(status.getDictVal())){
                    //当前状态非同步进行中
                    threadWait();
                    continue;
                }
                if(info==null || StringUtil.isEmpty(info.getDictVal())){
                    //未知的同步目标
                    threadWait();
                    continue;
                }
                DBDictEntity dict = dictService.getByKey(DBDictEntity.syncInterfacesKey());
                if(dict == null){
                    dict = new DBDictEntity();
                    dict.setDictKey(DBDictEntity.syncInterfacesKey());
                    dict.setDictVal("[]");
                    dict.setRemark("已经同步的接口集合");
                    dictService.save(dict);
                }
                DBProjectEntity project = projectService.getOne(
                        Wrappers.lambdaQuery(DBProjectEntity.class).eq(DBProjectEntity::getDefaultStatus, 1)
                );
                List<Long> ignoreIds = JsonUtil.jsonToList(dict.getDictVal(), Long.class);
                List<DBModuleInterfaceEntity> interfaces = interfaceService.list(
                        Wrappers.lambdaQuery(DBModuleInterfaceEntity.class)
                                .notIn(DBModuleInterfaceEntity::getId, ignoreIds)
                                .eq(DBModuleInterfaceEntity::getProjectId,project.getId())
                );
                if(CollectionUtils.isEmpty(interfaces)){
                    interfaces = Collections.emptyList();
                }
                OpenSyncDto dto = JsonUtil.jsonToBean(info.getDictVal(), OpenSyncDto.class);
                for (DBModuleInterfaceEntity anInterface : interfaces) {
                    status = dictService.getByKey(DBDictEntity.syncStatusKey());
                    if(status==null || "0".equals(status.getDictVal())){
                        break;
                    }
                    if(!doSync(anInterface, dto)){
                        try {
                            Thread.sleep(30*1000);
                            if(!doSync(anInterface, dto)){
                                break;
                            }
                        } catch (InterruptedException ignored) {}
                    }
                    ignoreIds.add(anInterface.getId());
                    dict.setDictVal(JsonUtil.beanToJson(ignoreIds));
                    dictService.updateById(dict);
                }
                if(status != null){
                    status.setDictVal("0");
                    dictService.updateById(status);
                }
                threadWait();
            }
        }).start();
    }

    /**
     * 真正执行同步
     */
    private static boolean doSync(DBModuleInterfaceEntity anInterface, OpenSyncDto dto){
        DBModuleControllerEntity controllerEntity = controllerService.getById(anInterface.getControllerId());
        DBInterfaceParamEntity query = new DBInterfaceParamEntity();
        query.setInterfaceId(anInterface.getId());
        query = paramService.getOne(Wrappers.lambdaQuery(query),false);
        SyncBody body = new SyncBody();
        body.setController(controllerEntity);
        body.setInterfaces(anInterface);
        body.setParams(query);
        return doSync(body,dto);
    }

    private static boolean doSync(SyncBody body, OpenSyncDto dto){
        body.setSecret(dto.getSecret());
        body.setUnique(dto.getProjectUnique());
        body.setName(dto.getProjectName());
        UnifiedAccessDto request = new UnifiedAccessDto();
        request.setApi("project::receiveSync");
        request.setBody(JsonUtil.beanToJson(body));
        HttpOperation operation = HttpUtilFactory.create(HttpImplEnum.httpClient);
        operation.getHttpReq().setUrl(dto.getAddress()+"/easyapi/doc/unified/post");
        operation.parameter(JsonUtil.beanToJson(request));
        operation.method(HttpMethod.POST);
        HttpRes res = operation.doUrl();
        return res.getResponseCode().equals(200)
                && !StringUtil.isEmpty(res.getResponseMsg())
                && JsonUtil.jsonToBean(res.getResponseMsg(), ResponseBody.class).getCode().equals(200);
    }
}
