package cn.easyutil.easyapi.logic.el;

import java.util.List;

/**
 * 转换为springEl
 */
public abstract class SpelParser {

    protected abstract boolean isVariable(String variableEl);

    protected abstract Object parseVariable(String variableEl);

    protected boolean isString(Object parseVal){
        return parseVal instanceof String;
    }

    public String parse(String el){
        if(!isVariable(el)){
            return el;
        }
        String parseEl = el;
        while (isVariable(parseEl)){
            List<String> customVariables = getCustomVariables(parseEl);
            for (String customVariable : customVariables) {
                Object val = parseVariable(customVariable);
                if(val == null){
                    parseEl = parseEl.replace(customVariable, "");
                    continue;
                }
                if(isVariable(val.toString())){
                    parseEl = parseEl.replace(customVariable, val.toString());
                    continue;
                }
                if(isString(val)){
                    val = "'"+val.toString()+"'";
                }
                parseEl = parseEl.replace(customVariable, val.toString());
            }
        }
        return parseEl;
    }

    protected abstract List<String> getCustomVariables(String el);
}
