package cn.easyutil.easyapi.logic.el;

import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.util.JsonUtil;

import java.util.ArrayList;
import java.util.List;

public class DefaultSpelValueParser extends SpelParser{

    private ApiEvaluationContext context;

    public void setContext(ApiEvaluationContext context){
        this.context = context;
    }

    public Object parseVariable(String variableEl,ApiEvaluationContext context){
        if(!variableEl.startsWith("$(") || !variableEl.endsWith(")")){
            return "'"+variableEl+"'";
        }
        variableEl = variableEl.substring(variableEl.indexOf("$(")+2, variableEl.length()-1);
        Object obj = ElDefaultMethodContext.getElVal(JsonUtil.beanToMap(context),variableEl);
        if(obj == null){
            return "";
        }
        return obj;
    }

    @Override
    protected boolean isVariable(String variableEl) {
        return variableEl!=null && variableEl.contains("$(") && variableEl.contains(")");
    }

    @Override
    protected Object parseVariable(String variableEl) {
        return parseVariable(variableEl, this.context==null?new ApiEvaluationContext():this.context);
    }

    @Override
    protected List<String> getCustomVariables(String el) {
        List<String> els = new ArrayList<>();
        String parseEl = el;
        while (parseEl.contains("$(")){
            String sub = parseEl.substring(parseEl.indexOf("$("));
            if(!sub.contains(")")){
                throw new ApidocException("表达式缺少右括号:"+sub);
            }
            //获取自定义表达式
            String easyapiEl = sub.substring(0,sub.indexOf(")")+1);
            els.add(easyapiEl);
            parseEl = parseEl.replace(easyapiEl, "");
        }
        return els;
    }
}
