package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import cn.easyutil.easyapi.handler.operator.provide.InterfaceReaderProvider;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.reflect.Method;

/**
 * 接口创建
 */
public class InterfaceCreator {

    private Method method;

    private DBModuleInterfaceEntity interfaceBean;

    private InterfaceReaderProvider filter = new InterfaceReaderProvider();

    private InterfaceExtra extra;

    private InterfaceCreator(){}

    public static InterfaceCreator builder(Method method){
        InterfaceCreator creator = new InterfaceCreator();
        creator.method = method;
        return creator;
    }

    public InterfaceCreator setFilter(InterfaceReaderProvider filter){
        if(filter == null){
            return this;
        }
        this.filter = filter;
        return this;
    }

    public DBModuleInterfaceEntity buildInterface(){
        if(interfaceBean != null){
            return interfaceBean;
        }
        try {
            create();
        }catch (Exception e){
            System.out.println("创建接口:"+method.toGenericString()+"失败,原因:"+e.getMessage());
            e.printStackTrace();
        }
        return interfaceBean;
    }

    /**
     * 创建接口说明
     */
    private void create() {
        interfaceBean = new DBModuleInterfaceEntity();
        interfaceBean.setShowName(filter.name(extra,null));
        interfaceBean.setShowType(filter.show(extra,null)?1:0);
        interfaceBean.setShowName(interfaceBean.getShowName().trim());
        interfaceBean.setMethodName(method.getName());
        interfaceBean.setDescription(filter.description(extra,null).trim());
        interfaceBean.setRequestMethod(filter.requestMethod(extra,null));
        RenewType renewType = filter.renewType(extra,null);
        interfaceBean.setRenewType(renewType==null? RenewType.increment.getType():renewType.getType());
        //外面添加
        interfaceBean.setBodyType(filter.bodyType(extra,null).getType());
        interfaceBean.setPinyin(StringUtil.toPinYin(interfaceBean.getShowName()).trim());
        interfaceBean.setSource(extra.getMethodComment().getSource());
        //添加额外信息
        interfaceBean.setCreateTime(System.currentTimeMillis());
        interfaceBean.setUpdateTime(System.currentTimeMillis());
        interfaceBean.setInterfaceUnique(StringUtil.toMD5(ProjectContext.currentProjectName+filter.unique(extra,null)));
        interfaceBean.setEnableReqPackage(filter.enableReqPackage(extra,null)?1:0);
        interfaceBean.setEnableResPackage(filter.enableResPackage(extra,null)?1:0);
        interfaceBean.setRequestUrl(filter.url(extra,null));
    }

    public InterfaceCreator setApiExtra(InterfaceExtra extra) {
        this.extra = extra;
        return this;
    }
}
