package cn.easyutil.easyapi.javadoc.reader;

import cn.easyutil.easyapi.util.StringUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JavaSourceComment {

    /**
     * 名称
     */
    private String name;

    /**
     * 处理过后的注释
     */
    private String comment;

    /**
     * 详细注释，根据@符号进行拆分
     */
    private List<CommentDetail> commentDetails;

    /**
     * 最开始的原始注释
     */
    private String commentOriginal;

    /**
     * 访问属性(public、private。。。)
     */
    private String modifyers;

    /**
     * 源码片段
     */
    private String source;

    /**
     * 每行源码内容
     */
    private List<String> lines;

    private List<AnnotationComment> annotations = new ArrayList<>();

    public void addAnnotation(AnnotationComment comment){
        annotations.add(comment);
    }

    public void addAllAnnotations(Collection<AnnotationComment> comments){
        if(comments != null){
            for (AnnotationComment annotationComment : comments) {
                addAnnotation(annotationComment);
            }
        }
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.commentOriginal = comment;
        if(!StringUtil.isEmpty(comment)){
            String processComment = comment.trim()
                    .replaceAll("[\r\n]", "")
                    .replaceAll("\\*", "")
            ;
            if(processComment.indexOf("@") > 0){
                processComment = processComment.substring(0, processComment.indexOf("@")).trim();
            }
            this.comment = processComment;
            String detail = comment;
            if(detail.contains("@")){
                detail = detail.substring(detail.indexOf("@"));
                String[] split = detail.split("@");
                List<CommentDetail> details = new ArrayList<>();
                for (String s : split) {
                    if(StringUtil.isEmpty(s)){
                        continue;
                    }
                    if(!s.contains(" ")){
                        continue;
                    }
                    CommentDetail commentDetail = new CommentDetail();
                    commentDetail.setKey(s.substring(0, s.indexOf(" ")));
                    commentDetail.setValue(s.substring(s.indexOf(" ")+1).trim()
                            .replaceAll("[\r\n]", "")
                            .replaceAll("\\*", ""));
                    details.add(commentDetail);
                }
                this.commentDetails = details;
            }
            return ;
        }
        this.comment = comment;
    }

    public List<AnnotationComment> getAnnotations() {
        return annotations;
    }

    public void setAnnotations(List<AnnotationComment> annotations) {
        this.annotations = annotations;
    }

    public String getModifyers() {
        return modifyers;
    }

    public void setModifyers(String modifyers) {
        if(!StringUtil.isEmpty(modifyers)){
            modifyers = modifyers.trim();
        }
        this.modifyers = modifyers;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public List<CommentDetail> getCommentDetails() {
        return commentDetails;
    }

    public void setCommentDetails(List<CommentDetail> commentDetails) {
        this.commentDetails = commentDetails;
    }

    public String getCommentOriginal() {
        return commentOriginal;
    }

    public void setCommentOriginal(String commentOriginal) {
        this.commentOriginal = commentOriginal;
    }

    public List<String> getLines() {
        return lines;
    }

    public void setLines(List<String> lines) {
        this.lines = lines;
    }
}
