package cn.easyutil.easyapi.javadoc.html;

import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.doc.*;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.interview.vo.FindControllerAndInterfaceVo;
import cn.easyutil.easyapi.mybatis.service.*;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ZipUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.FileCopyUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * 静态文件创建
 */
public class StaticDocCreate {

    private final UserService userService = new UserService();

    private final ControllerService controllerService = new ControllerService();

    private final InterfaceService interfaceService = new InterfaceService();

    private final InterfaceParamService paramService = new InterfaceParamService();

    private final SimpleUnitService unitService = new SimpleUnitService();

    private final ProjectService projectService = new ProjectService();

    private final OutPackageService outPackageService = new OutPackageService();

    private final ArticleService articleService = new ArticleService();

    private static final ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    /**
     * 导出静态文档
     */
    public void export(HttpServletResponse response,DBProjectEntity project) throws UnsupportedEncodingException {
        String basePath = project.getProjectName() + "-static-api";
        File zipFile = new File(basePath + "-api" + ".zip");
        File root = null;
        if (!zipFile.exists()) {
            synchronized (this) {
                if (!zipFile.exists()) {
                    root = createApiFolder(basePath,project.getId());
                    toZip(basePath, zipFile);
                }
            }
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(project.getProjectName() + "-apidoc.zip", "utf-8"));
        try (FileInputStream in = new FileInputStream(zipFile)) {
            byte[] but = new byte[1024 * 1024];
            int length;
            while ((length = in.read(but)) != -1) {
                response.getOutputStream().write(but, 0, length);
                response.getOutputStream().flush();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        //最后删除文件
        deepDelFile(zipFile);
        if (root != null) {
            deepDelFile(root);
        }
    }

    private void deepDelFile(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                file.delete();
            } else {
                Stream.of(files).forEach(this::deepDelFile);
                file.delete();
            }
        } else {
            file.delete();
        }
    }

    /**
     * 创建文档文件
     */
    private File createApiFolder(String basePath,Long projectId) {
        File root = new File(basePath);
        root.delete();
        root.mkdirs();
        //创建基础的文件
        createBaseFiles(basePath);
        //创建数据文件
        try {
            createStaticData(basePath,projectId);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return root;
    }

    /**
     * 创建基础文件
     *
     * @param basePath
     */
    private void createBaseFiles(String basePath) {
        //把所有文件全部load一遍，并放入root目录下，然后进行压缩，方便直接下载文件
        saveFile(basePath, resolver.getResource("classpath:static/apidoc.html"));
        saveFile(basePath, resolver.getResource("classpath:static/logo.png"));
        //处理css文件
        String cssPath = basePath + File.separator + "css";
        new File(cssPath).mkdirs();
        savePattenFiles(cssPath,"classpath:static/css/**.css");
        //处理fonts文件
        String fontPath = basePath + File.separator + "fonts";
        new File(fontPath).mkdirs();
        savePattenFiles(fontPath,"classpath:static/fonts/**");
        //处理img
        String imgPath = basePath + File.separator + "img";
        new File(imgPath).mkdirs();
        savePattenFiles(imgPath,"classpath:static/img/**.png");
        //处理js
        String jsPath = basePath + File.separator + "js";
        new File(jsPath).mkdirs();
        savePattenFiles(jsPath,"classpath:static/js/**.js");
    }


    /**
     * 创建数据文件
     */
    private void createStaticData(String basePath,Long projectId) throws Exception {
        //静态资源文件
        File dataFile = new File(basePath + File.separator + "StaticData.js");
        List<DBUserEntity> users = userService.list();
        List<DBModuleControllerEntity> controllers = controllerService.list(
                Wrappers.lambdaQuery(DBModuleControllerEntity.class)
                        .eq(DBModuleControllerEntity::getShow, 1)
                        .eq(DBModuleControllerEntity::getProjectId,projectId)
                        .orderByAsc(DBModuleControllerEntity::getSort)
                        .orderByAsc(DBModuleControllerEntity::getPinyin)
        );
        List<FindControllerAndInterfaceVo> controllerVos = new ArrayList<>();
        if (controllers != null && !controllers.isEmpty()) {
            for (DBModuleControllerEntity controller : controllers) {
                FindControllerAndInterfaceVo vo = new FindControllerAndInterfaceVo();
                BeanUtils.copyProperties(controller, vo);
                DBModuleInterfaceEntity queryIn = new DBModuleInterfaceEntity();
                queryIn.setControllerId(controller.getId());
                vo.setChildren(Optional.ofNullable(interfaceService.list(
                        Wrappers.lambdaQuery(queryIn)
                                .eq(DBModuleInterfaceEntity::getShowType, 1)
                                .eq(DBModuleInterfaceEntity::getProjectId,projectId)
                                .orderByAsc(DBModuleInterfaceEntity::getSort)
                                .orderByAsc(DBModuleInterfaceEntity::getPinyin))
                ).orElse(Collections.emptyList()));
                controllerVos.add(vo);
            }
        }
        List<DBModuleInterfaceEntity> interfaces = interfaceService.list(
                Wrappers.lambdaQuery(DBModuleInterfaceEntity.class)
                        .eq(DBModuleInterfaceEntity::getShowType, 1)
                        .eq(DBModuleInterfaceEntity::getProjectId,projectId)
                        .orderByAsc(DBModuleInterfaceEntity::getSort)
                        .orderByAsc(DBModuleInterfaceEntity::getPinyin));
        List<DBInterfaceParamEntity> params = paramService.list(Wrappers.lambdaQuery(DBInterfaceParamEntity.class).eq(DBInterfaceParamEntity::getProjectId,projectId));
        List<DBSimpleUnitEntity> units = unitService.list(Wrappers.lambdaQuery(DBSimpleUnitEntity.class).eq(DBSimpleUnitEntity::getProjectId,projectId));
        List<DBModuleOutPackageEntity> packages = outPackageService.list(Wrappers.lambdaQuery(DBModuleOutPackageEntity.class).eq(DBModuleOutPackageEntity::getProjectId,projectId));
        List<DBArticleEntity> articles = articleService.list(Wrappers.lambdaQuery(DBArticleEntity.class).eq(DBArticleEntity::getProjectId,projectId));
        DBProjectEntity project = projectService.getOne(Wrappers.lambdaQuery(DBProjectEntity.class).eq(DBProjectEntity::getId,projectId));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dataFile)));
        writer.write("var ApiProfile = {");
        writer.newLine();
        writer.write("isStatic: true,");
        writer.newLine();
        writer.write("project: " + JsonUtil.toJackson(project) + ",");
        writer.newLine();
        writer.write("userList: " + JsonUtil.toJackson(users) + ",");
        writer.newLine();
        writer.write("controllerList: " + JsonUtil.toJackson(controllerVos) + ",");
        writer.newLine();
        writer.write("interfaceList: " + JsonUtil.toJackson(interfaces) + ",");
        writer.newLine();
        writer.write("paramList: " + JsonUtil.toJackson(params) + ",");
        writer.newLine();
        writer.write("unitList: " + JsonUtil.toJackson(units) + ",");
        writer.newLine();
        writer.write("paramPackages: " + JsonUtil.toJackson(packages) + ",");
        writer.newLine();
        writer.write("articles: " + JsonUtil.toJackson(articles) + ",");
        writer.newLine();
        writer.write("}");
        writer.flush();
        writer.close();
    }

    private void saveFile(String basePath, Resource resource) {
        String filename = basePath + File.separator + resource.getFilename();
        try (InputStream inputStream = resource.getInputStream()) {
            FileCopyUtils.copy(inputStream, new FileOutputStream(new File(filename)));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void savePattenFiles(String basePath,String patten){
        try {
            Resource[] resources = resolver.getResources(patten);
            for (Resource resource : resources) {
                saveFile(basePath,resource);
            }
        }catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 压缩
     */
    private void toZip(String folderPath, File zipFile) {
        try (FileOutputStream fos1 = new FileOutputStream(zipFile)) {
            ZipUtil.toZip(folderPath, fos1, true);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
