package cn.easyutil.easyapi.interview;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.NumberSerializer;

import java.io.IOException;

public class JacksonBigLongTypeSerializer extends NumberSerializer {

    public final static JacksonBigLongTypeSerializer instance = new JacksonBigLongTypeSerializer(Long.class);

    protected JacksonBigLongTypeSerializer(Class t) {
        super(t);
    }

    public JacksonBigLongTypeSerializer(){
        super(Long.class);
    }

    @Override
    public void serialize(Number value, JsonGenerator g, SerializerProvider provider) throws IOException {
        if(value instanceof Long){
            Long val = (Long) value;
            if(val.toString().length() > 15){
                g.writeString(val.toString());
                return;
            }
        }
        super.serialize(value, g, provider);
    }
}
