package cn.easyutil.easyapi.hook;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.db.doc.DBArticleEntity;
import cn.easyutil.easyapi.mybatis.service.ArticleService;

import java.util.ArrayList;
import java.util.List;

public class DefaultApiRunAround implements ApiRunAround {

    private ArticleService articleService;

    public void setArticleService(ArticleService articleService) {
        this.articleService = articleService;
    }

    @Override
    public void apiCreated() {
        if(!ProjectContext.allConfiguration.getConfiguration().isShowBanner()){
            return ;
        }
        String text = "                                        _\n" +
                "                                       (_)\n" +
                "  ___  __ _ ___ _   _ ______ __ _ _ __  _\n" +
                " / _ \\/ _` / __| | | |______/ _` | '_ \\| |\n" +
                "|  __/ (_| \\__ \\ |_| |     | (_| | |_) | |\n" +
                " \\___|\\__,_|___/\\__, |      \\__,_| .__/|_|\n" +
                "                 __/ |           | |\n" +
                "                |___/            |_|\n" +
                "    -------------------------------接口文档-v0.8.5.6\n" +
                "    ---http://localhost:项目端口/apidoc.html";
        System.out.println(text);
        System.out.println("*********************************************");
        System.out.println("**********   接口文档已生成 url=/apidoc.html  ***************");
        System.out.println("*********************************************");
    }

    @Override
    public void dbCleared() {
        List<DBArticleEntity> articles = new ArrayList<>();
        DBArticleEntity a1 = new DBArticleEntity();
        a1.setTitle("欢迎使用easyapi");
        a1.setContent("小明，起来致欢迎辞");
        articles.add(a1);

        DBArticleEntity a2 = new DBArticleEntity();
        a2.setTitle("如何使用自定义变量");
        a2.setContent("在任意输入框中填写 {{变量名}} 即可");
        articles.add(a2);

        DBArticleEntity a3 = new DBArticleEntity();
        a3.setTitle("如何切换请求环境");
        a3.setContent("在顶部设置里面有请求环境设置，可以增删环境，同时在接口模拟请求页面选择环境");
        articles.add(a3);
        articleService = new ArticleService();
        articleService.saveBatch(articles);
    }

    @Override
    public void beforeCreateApi() {
        System.out.println("easyapi开始扫描接口文档。。。");
    }
}
