package cn.easyutil.easyapi.handler.reader.responses.model;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ResponseExtra;
import cn.easyutil.easyapi.logic.creator.MethodParam;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public class ResponseReturnTypesCommentReader extends HandlerChain<ResponseExtra,List<MethodParam>> {

    @Override
    public List<MethodParam> resolve(ResponseExtra extra, List<MethodParam> transfer) {
        if(transfer != null){
            return nextHandler().resolve(extra, transfer);
        }
        Method method = extra.getInterfaceExtra().getMethod();
        MethodParam param = new MethodParam();
        param.setParamType(method.getGenericReturnType());
        return nextHandler().resolve(extra, Collections.singletonList(param));
    }
}
