package cn.easyutil.easyapi.handler.reader.responses.model;

import cn.easyutil.easyapi.util.ApidocCommentUtil;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ResponseExtra;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.logic.creator.CreatorCommonMethod;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.reflect.Method;

public class ResponseMockTemplateCommentReader extends HandlerChain<ResponseExtra,String> {

    @Override
    public String resolve(ResponseExtra extra, String transfer) {
        if(transfer != null){
            return nextHandler().resolve(extra, transfer);
        }
        Method method = extra.getInterfaceExtra().getMethod();
        if(method == null){
            return nextHandler().resolve(extra, transfer);
        }
        MethodComment methodComment = extra.getInterfaceExtra().getMethodComment();
        String template = CreatorCommonMethod.mockTemplate(method.getAnnotations());
        if(methodComment!=null && !StringUtil.isEmpty(methodComment.getReturnComment())){
            String mockValue = ApidocCommentUtil.getCommentValue(methodComment.getReturnComment(), "mockValue");
            if(!StringUtil.isEmpty(mockValue)){
                return nextHandler().resolve(extra, mockValue);
            }
        }
        return nextHandler().resolve(extra, template);
    }
}
