package cn.easyutil.easyapi.handler.reader.interfaces.model;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import cn.easyutil.easyapi.util.SpringUtil;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.reflect.Method;
import java.util.Optional;

public class InterfaceRequestUrlCommentReader extends HandlerChain<InterfaceExtra,String> {

    /**
     * 完善请求路径
     *
     * @param requestUrl
     * @return
     */
    private String parseUrl(String requestUrl) {
        if (!requestUrl.startsWith("/")) {
            requestUrl = "/" + requestUrl;
        }
        if (requestUrl.endsWith("/")) {
            requestUrl = requestUrl.substring(0, requestUrl.length() - 1);
        }
        return requestUrl;
    }

    @Override
    public String resolve(InterfaceExtra extra, String transfer) {
        Method method = extra.getMethod();
        String baseUrl = Optional.ofNullable(extra.getControllerExtra().getDbController().getApiPath()).orElse("");
        baseUrl = parseUrl(baseUrl);
        String mapping = Optional.ofNullable(SpringUtil.getRequestPath(method)).orElse("");
        if (!StringUtil.isEmpty(mapping)) {
            mapping =  parseUrl(mapping);
        }
        return nextHandler().resolve(extra, baseUrl+mapping);
    }
}
