package cn.easyutil.easyapi.handler.reader.interfaces.model;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import cn.easyutil.easyapi.util.AnnotationUtil;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class InterfaceIgnoreSwaggerReader extends HandlerChain<InterfaceExtra,Boolean> {

    @Override
    public Boolean resolve(InterfaceExtra extra, Boolean transfer) {
        Method method = extra.getMethod();
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiOperation", method.getAnnotations());
        if(annotation != null){
            Object hidden = AnnotationUtil.getAnnotationValue(annotation, "hidden");
            if(hidden != null){
                return nextHandler().resolve(extra, (Boolean) hidden);
            }
        }
        return nextHandler().resolve(extra, transfer);
    }
}
