package cn.easyutil.easyapi.handler.reader.interfaces.model;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import cn.easyutil.easyapi.javadoc.reader.CommentDetail;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.util.CollectionUtils;

import java.util.Optional;

public class InterfaceDescCommentReader extends HandlerChain<InterfaceExtra,String> {

    @Override
    public String resolve(InterfaceExtra extra, String transfer) {
        if(!StringUtil.isEmpty(transfer)){
            return nextHandler().resolve(extra, transfer);
        }
        MethodComment methodComment = extra.getMethodComment();
        if(methodComment==null || CollectionUtils.isEmpty(methodComment.getCommentDetails())){
            return nextHandler().resolve(extra, transfer);
        }
        Optional<CommentDetail> apiNote = methodComment.getCommentDetails().stream().filter(item -> item.getKey().equals("apiNote")).findFirst();
        return nextHandler().resolve(extra, apiNote.map(CommentDetail::getValue).orElse(transfer));
    }
}
