package cn.easyutil.easyapi.handler.reader.interfaces.model;

import cn.easyutil.easyapi.entity.common.BodyType;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.multipart.MultipartFile;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class InterfaceBodyTypeCommentReader extends HandlerChain<InterfaceExtra,BodyType> {

    @Override
    public BodyType resolve(InterfaceExtra extra, BodyType transfer) {
        Method method = extra.getMethod();
        Parameter[] parameters = method.getParameters();
        if (parameters == null || parameters.length == 0) {
            // 无入参
            return nextHandler().resolve(extra,BodyType.FORM);
        }
        for (Parameter parameter : parameters) {
            RequestBody annotation = parameter.getAnnotation(RequestBody.class);
            if (annotation != null) {
                return nextHandler().resolve(extra,BodyType.JSON);
            }
            // 文件上传
            if (parameter.getType().getCanonicalName().equals(MultipartFile.class.getCanonicalName())
                    || parameter.getType().getCanonicalName().equals(MultipartFile[].class.getCanonicalName())) {
                return nextHandler().resolve(extra,BodyType.UPLOAD);
            }
        }
        return nextHandler().resolve(extra,transfer);
    }
}
