package cn.easyutil.easyapi.handler.reader.interfaces;

import cn.easyutil.easyapi.entity.common.BodyType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.handler.BaseHandlerChain;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ControllerExtra;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class InterfaceReaderHandler extends BaseHandlerChain {

    private static final List<HandlerChain<InterfaceExtra,BodyType>> bodyTypeHandlers = new ArrayList<>();
    private static final List<HandlerChain<InterfaceExtra,List<String>>> searchHandlers = new ArrayList<>();
    private static final List<HandlerChain<InterfaceExtra,String>> descriptionHandlers = new ArrayList<>();
    private static final List<HandlerChain<InterfaceExtra,Boolean>> enableReqPackageHandlers = new ArrayList<>();
    private static final List<HandlerChain<InterfaceExtra,Boolean>> enableResPackageHandlers = new ArrayList<>();
    private static final List<HandlerChain<InterfaceExtra,Boolean>> ignoreHandlers = new ArrayList<>();
    private static final List<HandlerChain<InterfaceExtra,RenewType>> renewTypeHandlers = new ArrayList<>();
    private static final List<HandlerChain<InterfaceExtra,RequestMethod>> requestMethodHandlers = new ArrayList<>();
    private static final List<HandlerChain<InterfaceExtra,String>> requestNoteHandlers = new ArrayList<>();
    private static final List<HandlerChain<InterfaceExtra,String>> urlHandlers = new ArrayList<>();
    private static final List<HandlerChain<InterfaceExtra,String>> responseNoteHandlers = new ArrayList<>();
    private static final List<HandlerChain<ControllerExtra,List<Method>>> scanHandlers = new ArrayList<>();
    private static final List<HandlerChain<InterfaceExtra,Boolean>> showHandlers = new ArrayList<>();
    private static final List<HandlerChain<InterfaceExtra,String>> nameHandlers = new ArrayList<>();
    private static final List<HandlerChain<InterfaceExtra,String>> uniqueHandlers = new ArrayList<>();
    private static final List<HandlerChain<InterfaceExtra,Boolean>> verifyMockTagHandlers = new ArrayList<>();

    static {
        new DefaultInterfaceReaderHandler().addDefault();
    }

    public static void addBodyTypeHandlers(HandlerChain<InterfaceExtra,BodyType> handler) {
        addChain(bodyTypeHandlers,handler);
    }

    public static void addSearchHandlers(HandlerChain<InterfaceExtra,List<String>> handler) {
        addChain(searchHandlers,handler);
    }

    public static void addDescriptionHandlers(HandlerChain<InterfaceExtra,String> handler) {
        addChain(descriptionHandlers,handler);
    }

    public static void addEnableReqPackageHandlers(HandlerChain<InterfaceExtra,Boolean> handler) {
        addChain(enableReqPackageHandlers,handler);
    }

    public static void addEnableResPackageHandlers(HandlerChain<InterfaceExtra,Boolean> handler) {
        addChain(enableResPackageHandlers,handler);
    }

    public static void addIgnoreHandlers(HandlerChain<InterfaceExtra,Boolean> handler) {
        addChain(ignoreHandlers,handler);
    }

    public static void addRenewTypeHandlers(HandlerChain<InterfaceExtra,RenewType> handler) {
        addChain(renewTypeHandlers,handler);
    }

    public static void addRequestMethodHandlers(HandlerChain<InterfaceExtra,RequestMethod> handler) {
        addChain(requestMethodHandlers,handler);
    }

    public static void addRequestNoteHandlers(HandlerChain<InterfaceExtra,String> handler) {
        addChain(requestNoteHandlers,handler);
    }

    public static void addUrlHandlers(HandlerChain<InterfaceExtra,String> handler) {
        addChain(urlHandlers,handler);
    }

    public static void addResponseNoteHandlers(HandlerChain<InterfaceExtra,String> handler) {
        addChain(responseNoteHandlers,handler);
    }

    public static void addScanHandlers(HandlerChain<ControllerExtra,List<Method>> handler) {
        addChain(scanHandlers,handler);
    }

    public static void addShowHandlers(HandlerChain<InterfaceExtra,Boolean> handler) {
        addChain(showHandlers,handler);
    }

    public static void addNameHandlers(HandlerChain<InterfaceExtra,String> handler) {
        addChain(nameHandlers,handler);
    }

    public static void addUniqueHandlers(HandlerChain<InterfaceExtra,String> handler) {
        addChain(uniqueHandlers,handler);
    }

    public static void addVerifyMockTagHandlers(HandlerChain<InterfaceExtra,Boolean> handler) {
        addChain(verifyMockTagHandlers,handler);
    }


    public static List<HandlerChain<InterfaceExtra,BodyType>> getBodyTypeHandlers() {
        return bodyTypeHandlers;
    }

    public static List<HandlerChain<InterfaceExtra,List<String>>> getSearchHandlers() {
        return searchHandlers;
    }

    public static List<HandlerChain<InterfaceExtra,String>> getDescriptionHandlers() {
        return descriptionHandlers;
    }

    public static List<HandlerChain<InterfaceExtra,Boolean>> getEnableReqPackageHandlers() {
        return enableReqPackageHandlers;
    }

    public static List<HandlerChain<InterfaceExtra,Boolean>> getEnableResPackageHandlers() {
        return enableResPackageHandlers;
    }

    public static List<HandlerChain<InterfaceExtra,Boolean>> getIgnoreHandlers() {
        return ignoreHandlers;
    }

    public static List<HandlerChain<InterfaceExtra,RenewType>> getRenewTypeHandlers() {
        return renewTypeHandlers;
    }

    public static List<HandlerChain<InterfaceExtra,RequestMethod>> getRequestMethodHandlers() {
        return requestMethodHandlers;
    }

    public static List<HandlerChain<InterfaceExtra,String>> getRequestNoteHandlers() {
        return requestNoteHandlers;
    }

    public static List<HandlerChain<InterfaceExtra,String>> getUrlHandlers() {
        return urlHandlers;
    }

    public static List<HandlerChain<InterfaceExtra,String>> getResponseNoteHandlers() {
        return responseNoteHandlers;
    }

    public static List<HandlerChain<ControllerExtra,List<Method>>> getScanHandlers() {
        return scanHandlers;
    }

    public static List<HandlerChain<InterfaceExtra,Boolean>> getShowHandlers() {
        return showHandlers;
    }

    public static List<HandlerChain<InterfaceExtra,String>> getNameHandlers() {
        return nameHandlers;
    }

    public static List<HandlerChain<InterfaceExtra,String>> getUniqueHandlers() {
        return uniqueHandlers;
    }

    public static List<HandlerChain<InterfaceExtra,Boolean>> getVerifyMockTagHandlers() {
        return verifyMockTagHandlers;
    }
}
