package cn.easyutil.easyapi.handler.reader.controllers;

import cn.easyutil.easyapi.handler.reader.controllers.model.*;

public class DefaultControllerReaderHandler {

    public void addDefault(){
        addAuthors();
        addDescriptions();
        addIgnores();
        addPaths();
        addShows();
        addNames();
        scans();
    }

    private void scans(){
        ControllerReaderHandler.addScanHandlers(new ControllerScanCommonReader());
    }

    private void addNames(){
        ControllerReaderHandler.addNameHandlers(new ControllerShowNameApiReader());
        ControllerReaderHandler.addNameHandlers(new ControllerShowNameSwaggerReader());
        ControllerReaderHandler.addNameHandlers(new ControllerShowNameCommentReader());
    }

    private void addShows(){
        ControllerReaderHandler.addShowHandlers(new ControllerShowApiReader());
        ControllerReaderHandler.addShowHandlers(new ControllerShowCommentReader());
        ControllerReaderHandler.addShowHandlers(new ControllerShowSwaggerReader());
    }

    private void addPaths(){
        ControllerReaderHandler.addPathHandlers(new ControllerRequestPathApiReader());
        ControllerReaderHandler.addPathHandlers(new ControllerRequestPathCommentReader());
        ControllerReaderHandler.addPathHandlers(new ControllerRequestPathSwaggerReader());
    }

    private void addDescriptions(){
        ControllerReaderHandler.addDescriptionHandlers(new ControllerDescApiReader());
        ControllerReaderHandler.addDescriptionHandlers(new ControllerDescCommentReader());
        ControllerReaderHandler.addDescriptionHandlers(new ControllerDescSwaggerReader());
    }

    private void addAuthors(){
        ControllerReaderHandler.addAuthorHandlers(new ControllerAuthorApiReader());
        ControllerReaderHandler.addAuthorHandlers(new ControllerAuthorCommentReader());
        ControllerReaderHandler.addAuthorHandlers(new ControllerAuthorSwaggerReader());
    }

    private void addIgnores(){
        ControllerReaderHandler.addIgnoreHandlers(new ControllerIgnoreApiReader());
        ControllerReaderHandler.addIgnoreHandlers(new ControllerIgnoreCommentReader());
        ControllerReaderHandler.addIgnoreHandlers(new ControllerIgnoreSwaggerReader());
    }
}
