package cn.easyutil.easyapi.handler.reader.beans.model;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;
import cn.easyutil.easyapi.util.AnnotationUtil;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.annotation.Annotation;

public class BeanDescriptionSwaggerReader extends HandlerChain<ModelFieldExtra,String> {

    @Override
    public String resolve(ModelFieldExtra extra, String transfer) {
        if(extra.getField()==null || !StringUtil.isEmpty(transfer)){
            return nextHandler().resolve(extra, transfer);
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiModelProperty", extra.getField().getAnnotations());
        if(annotation != null){
            Object value = AnnotationUtil.getAnnotationValue(annotation, "value");
            if(!StringUtil.isEmpty(value)){
                return nextHandler().resolve(extra, value.toString());
            }
        }
        return nextHandler().resolve(extra, transfer);
    }
}
