package cn.easyutil.easyapi.handler.reader.beans;

import cn.easyutil.easyapi.handler.reader.beans.model.*;

public class DefaultBeanReaderHandler {

    public void addDefault(){
        addConditions();
        addDescriptions();
        addIgnores();
        addJavaTypes();
        addMockTemplates();
        addParams();
        addRequires();
        addShows();
        addTypes();
    }

    private void addTypes(){
        BeanReaderHandler.addTypeHandlers(new BeanTypeCommentReader());
    }

    private void addShows(){
        BeanReaderHandler.addShowHandlers(new BeanShowApiReader());

        BeanReaderHandler.addShowHandlers(new BeanShowSwaggerReader());
    }

    private void addRequires(){
        BeanReaderHandler.addRequiredHandlers(new BeanRequiredApiReader());

        BeanReaderHandler.addRequiredHandlers(new BeanRequiredSwaggerReader());
    }

    private void addParams(){
        BeanReaderHandler.addParamHandlers(new BeanParamsCommentReader());
    }

    private void addMockTemplates(){
        BeanReaderHandler.addMockTemplateHandlers(new BeanMockTemplateCommentReader());
    }

    /**
     * 添加javaType规则
     */
    private void addJavaTypes(){
        BeanReaderHandler.addJavaTypeHandlers(new BeanJavaTypeCommentReader());
    }

    /**
     * 添加忽略规则
     */
    private void addIgnores(){
        BeanReaderHandler.addIgnoreHandlers(new BeanIgnoreApiReader());

        BeanReaderHandler.addIgnoreHandlers(new BeanIgnoreCommentReader());
    }


    /**
     * 添加默认字段说明实现
     */
    private void addDescriptions(){
        BeanReaderHandler.addDescriptionHandlers(new BeanDescriptionApiReader());

        BeanReaderHandler.addDescriptionHandlers(new BeanDescriptionSwaggerReader());

        BeanReaderHandler.addDescriptionHandlers(new BeanDescriptionCommentReader());

    }

    private void addConditions(){
        BeanReaderHandler.addConditionHandlers(new BeanConditionCommentReader());
    }
}
