package cn.easyutil.easyapi.handler.operator.provide;

import cn.easyutil.easyapi.handler.operator.RequestReader;
import cn.easyutil.easyapi.util.ApidocCommentUtil;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.RequestExtra;
import cn.easyutil.easyapi.handler.reader.requests.*;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.javadoc.reader.SourceParameterComment;
import cn.easyutil.easyapi.logic.creator.MethodParam;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RequestReaderProvider implements RequestReader {

    @Override
    public List<String> conditions(RequestExtra extra, List<String> transfer) {
        HandlerChain<RequestExtra,List<String>> start = RequestReaderHandler.useFirst(RequestReaderHandler.getConditionHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse(new ArrayList<>());
    }

    @Override
    public String description(RequestExtra extra, String transfer) {
        HandlerChain<RequestExtra,String> start = RequestReaderHandler.useFirst(RequestReaderHandler.getDescriptionHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse("");
    }

    @Override
    public Boolean ignore(RequestExtra extra, Boolean transfer) {
        HandlerChain<RequestExtra,Boolean> start = RequestReaderHandler.useFirst(RequestReaderHandler.getIgnoreHandlers());
        Boolean resolve = start.resolve(extra, transfer);
        if(resolve != null){
            return resolve;
        }
        MethodComment methodComment = extra.getInterfaceExtra().getMethodComment();
        if(methodComment!=null && !StringUtil.isEmpty(extra.getParameterName()) && methodComment.getParameter(extra.getParameterName())!=null){
            SourceParameterComment parameter = methodComment.getParameter(extra.getParameterName());
            if(!StringUtil.isEmpty(parameter.getComment())){
                String ignore = ApidocCommentUtil.getCommentValue(parameter.getComment(), "ignore");
                if(!StringUtil.isEmpty(ignore)){
                    return "true".equalsIgnoreCase(ignore);
                }
            }
        }
        return false;
    }

    @Override
    public String mockTemplate(RequestExtra extra, String transfer) {
        HandlerChain<RequestExtra,String> start = RequestReaderHandler.useFirst(RequestReaderHandler.getDescriptionHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse("");
    }

    @Override
    public String name(RequestExtra extra, String transfer) {
        HandlerChain<RequestExtra,String> start = RequestReaderHandler.useFirst(RequestReaderHandler.getDescriptionHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse(extra.getParameterName());
    }

    @Override
    public List<MethodParam> params(RequestExtra extra, List<MethodParam> transfer) {
        HandlerChain<RequestExtra,List<MethodParam>> start = RequestReaderHandler.useFirst(RequestReaderHandler.getParamHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse(new ArrayList<>());
    }

    @Override
    public Boolean required(RequestExtra extra, Boolean transfer) {
        HandlerChain<RequestExtra,Boolean> start = RequestReaderHandler.useFirst(RequestReaderHandler.getRequiredHandlers());
        Boolean resolve = start.resolve(extra, transfer);
        if(resolve != null){
            return resolve;
        }
        MethodComment methodComment = extra.getInterfaceExtra().getMethodComment();
        if(methodComment!=null && !StringUtil.isEmpty(extra.getParameterName()) && methodComment.getParameter(extra.getParameterName())!=null){
            String required = ApidocCommentUtil.getCommentValue(methodComment.getParameter(extra.getParameterName()).getComment(), "required");
            if(!StringUtil.isEmpty(required)){
                return "true".equalsIgnoreCase(required);
            }
        }
        return true;
    }

    @Override
    public Boolean show(RequestExtra extra, Boolean transfer) {
        HandlerChain<RequestExtra,Boolean> start = RequestReaderHandler.useFirst(RequestReaderHandler.getShowHandlers());
        Boolean resolve = start.resolve(extra, transfer);
        if(resolve != null){
            return resolve;
        }
        MethodComment methodComment = extra.getInterfaceExtra().getMethodComment();
        if(methodComment!=null && !StringUtil.isEmpty(extra.getParameterName()) && methodComment.getParameter(extra.getParameterName())!=null){
            String hidden = ApidocCommentUtil.getCommentValue(methodComment.getParameter(extra.getParameterName()).getComment(), "hidden");
            if(!StringUtil.isEmpty(hidden)){
                return "false".equalsIgnoreCase(hidden);
            }
        }
        return true;
    }

    @Override
    public Type type(RequestExtra extra, Type transfer) {
        HandlerChain<RequestExtra,Type> start = RequestReaderHandler.useFirst(RequestReaderHandler.getTypeHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse(extra.getType());
    }
}
