package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.util.StringUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import org.apache.commons.codec.Charsets;
import org.apache.ibatis.type.JdbcType;

import java.sql.Blob;

/**
 * 控制器
 */
@TableName("EASYAPI_MODULE_CONTROLLER")
public class DBModuleControllerEntity extends BaseDbEntity {

	@DDL(value = "MODULE_ID",ddl = "`MODULE_ID` bigint(20) DEFAULT NULL COMMENT '所属模块id'")
	@ApidocComment("所属模块id")
	private Long moduleId;

	@DDL(value = "CLASS_NAME",ddl = "`CLASS_NAME` varchar(100) DEFAULT 0 COMMENT '控制器全类名'")
 	@ApidocComment("控制器全类名")
 	private String className;

	@DDL(value = "SHOW_NAME",ddl = "`SHOW_NAME` varchar(100) DEFAULT NULL COMMENT '控制器名称'")
	@ApidocComment("控制器名称")
 	private String showName;

	@DDL(value = "DESCRIPTION",ddl = "`DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '控制器说明'")
	@ApidocComment("控制器说明")
	private String description;

	@DDL(value = "AUTHOR",ddl = "`AUTHOR` varchar(100) DEFAULT NULL COMMENT '控制器作者'")
	@ApidocComment("控制器作者")
	private String author;

	@DDL(value = "PINYIN",ddl = "`PINYIN` varchar(255) DEFAULT NULL COMMENT '控制器名称拼音'")
	@ApidocComment("控制器名称拼音")
 	private String pinyin;

	@DDL(value = "API_PATH",ddl = "`API_PATH` varchar(50) DEFAULT NULL COMMENT '统一请求的父路径'")
 	@ApidocComment("统一请求的父路径")
 	private String apiPath;

	@DDL(value = "SORT",ddl = "`SORT` int(5) DEFAULT 0 COMMENT '排序值,值越小，排名越靠前'")
 	@ApidocComment("排序值,值越小，排名越靠前")
 	private Integer sort = 0;

	@TableField(exist = false)
	private String source;

	@DDL(value = "SOURCE_BYTES",type = Blob.class,ddl = "`SOURCE_BYTES` BLOB DEFAULT NULL COMMENT '源代码'")
	@ApidocComment("源代码")
	@TableField(jdbcType = JdbcType.BLOB)
	private byte[] sourceBytes;

	@DDL(value = "SEARCH_TAGS",ddl = "`SEARCH_TAGS` varchar(255) DEFAULT NULL COMMENT '搜索字段'")
	@ApidocComment("搜索字段")
	private String searchTags;

	@DDL(value = "SHOW",ddl = "`SHOW` int(1) DEFAULT 1 COMMENT '是否展示 0-否  1-是'")
	@ApidocComment("是否展示 0-否  1-是")
	@TableField("`show`")
	private Integer show;

	public static String buildSearchTag(DBModuleControllerEntity entity){
		if(entity == null){
			return "";
		}
		StringBuilder sb = new StringBuilder();
		if(!StringUtil.isEmpty(entity.getShowName())){
			sb.append(entity.getShowName());
		}
		if(!StringUtil.isEmpty(entity.getApiPath())){
			sb.append(entity.getApiPath());
		}
		if(!StringUtil.isEmpty(entity.getAuthor())){
			sb.append(entity.getAuthor());
		}
		if(!StringUtil.isEmpty(entity.getPinyin())){
			sb.append(entity.getPinyin());
		}
		return sb.toString();
	}

	public Long getModuleId() {
		return moduleId;
	}

	public void setModuleId(Long moduleId) {
		this.moduleId = moduleId;
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getShowName() {
		return showName;
	}

	public void setShowName(String showName) {
		if(!StringUtil.isEmpty(showName) && showName.length()>150){
			showName = showName.substring(0, 150);
		}
		this.showName = showName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		this.author = author;
	}

	public String getPinyin() {
		return pinyin;
	}

	public void setPinyin(String pinyin) {
		if(!StringUtil.isEmpty(pinyin) && pinyin.length()>150){
			pinyin = pinyin.substring(0, 150);
		}
		this.pinyin = pinyin;
	}

	public String getApiPath() {
		return apiPath;
	}

	public void setApiPath(String apiPath) {
		this.apiPath = apiPath;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	public String getSearchTags() {
		return searchTags;
	}

	public void setSearchTags(String searchTags) {
		this.searchTags = searchTags;
	}

	public Integer getShow() {
		return show;
	}

	public void setShow(Integer show) {
		this.show = show;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
		this.sourceBytes = StringUtil.isEmpty(source)?null:source.getBytes(Charsets.UTF_8);
	}

	public byte[] getSourceBytes() {
		return sourceBytes;
	}

	public void setSourceBytes(byte[] sourceBytes) {
		this.sourceBytes = sourceBytes;
		this.source = sourceBytes==null?null:new String(sourceBytes,Charsets.UTF_8);
	}
}