package cn.easyutil.easyapi.entity.auth;

import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 权限功能模块
 */
public enum AuthModule {

    /** 同步接口*/
    manualSync(10001,"同步接口","MANUALSYNC"),

    manualSyncAll(10002,"同步全部文档","MANUALSYNCALL"),

    getInfo(20001,"查看文档说明","GETINFO",1),

    updateInfo(20201,"修改文档说明","UPDATEINFO"),

    getOutPackage(20002,"查看返回外包装","GETOUTPACKAGE",1),

    updateOutPackage(20301,"修改返回外包装","UPDATEOUTPACKAGE"),

    getControllers(30001,"查看控制器列表","GETCONTROLLERS",1),

    findInterfaces(40001,"搜索接口","FINDINTERFACES",1),

    getInterfaces(40002,"查看全部接口","GETINTERFACES",1),

    addInterfaces(40101,"添加接口","ADDINTERFACES"),

    updateInteface(40201,"修改接口信息","UPDATEINTEFACE"),

    delInterfaces(40301,"删除接口","DELINTERFACES"),

    mock(50001,"mock返回数据","MOCK",1),

    updateMock(50201,"修改mock数据","UPDATEMOCK"),

    getRequestParam(60001,"查看请求参数","GETREQUESTPARAM",1),

    updateRequestParams(60201,"修改请求参数","UPDATEREQUESTPARAMS"),

    getResponseParam(70001,"查看响应参数","GETRESPONSEPARAM",1),

    updateResponseParams(70201,"修改响应参数","UPDATERESPONSEPARAMS"),

    doUrl(80001,"真实环境请求","DOURL"),

    unknow(-1,"未知功能","unknow");

    private Integer authCode;
    //是否默认通用权限
    private Integer defaultStatus = 0;
    private String moduleRemark;
    private String moduleName;

    AuthModule(Integer authCode, String moduleRemark, String moduleName){
        this.authCode = authCode;
        this.moduleRemark = moduleRemark;
        this.moduleName = moduleName;
    }

    AuthModule(Integer authCode, String moduleRemark, String moduleName, Integer defaultStatus){
        this.authCode = authCode;
        this.moduleRemark = moduleRemark;
        this.moduleName = moduleName;
        this.defaultStatus = defaultStatus;
    }

    public static AuthModule getByCode(Integer code){
        return Arrays.stream(AuthModule.values()).filter(am -> am.getAuthCode().equals(code)).findFirst().orElse(unknow);
    }

    public static List<Integer> allCode(){
        return Stream.of(AuthModule.values()).filter(am -> am!=unknow).map(AuthModule::getAuthCode).collect(Collectors.toList());
    }

    public static List<AuthModule> allModule(List<Integer> codes){
        List<AuthModule> authModules = Arrays.asList(AuthModule.values());
        if(CollectionUtils.isEmpty(codes)){
            return authModules;
        }
        return authModules.stream().filter(am -> am!=unknow).filter(m -> codes.contains(m.getAuthCode())).collect(Collectors.toList());
    }

    public static List<Integer> getDefaultAuthCodes(){
        return Stream.of(AuthModule.values()).filter(module -> module.getDefaultStatus()==1).map(AuthModule::getAuthCode).collect(Collectors.toList());
    }

    public Integer getAuthCode() {
        return authCode;
    }

    public void setAuthCode(Integer authCode) {
        this.authCode = authCode;
    }

    public Integer getDefaultStatus() {
        return defaultStatus;
    }

    public void setDefaultStatus(Integer defaultStatus) {
        this.defaultStatus = defaultStatus;
    }

    public String getModuleRemark() {
        return moduleRemark;
    }

    public void setModuleRemark(String moduleRemark) {
        this.moduleRemark = moduleRemark;
    }

    public String getModuleName() {
        return moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }
}
