package cn.easyutil.easyapi.configuration.filter;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ResponseExtra;
import cn.easyutil.easyapi.logic.creator.MethodParam;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 控制器解析
 */
@Component
@ConfigurationProperties(prefix = "easyapi.filter.response")
public class EasyApiResponseReaderFilter {

    //字段说明
    private List<Class<List<HandlerChain<ResponseExtra,String>>>> description = new ArrayList<>();

    //忽略
    private List<Class<List<HandlerChain<ResponseExtra,Boolean>>>> ignore = new ArrayList<>();

    //mock模板
    private List<Class<List<HandlerChain<ResponseExtra,String>>>> mockTemplate = new ArrayList<>();

    //是否必填
    private List<Class<List<HandlerChain<ResponseExtra,Boolean>>>> required = new ArrayList<>();

    //是否显示
    private List<Class<List<HandlerChain<ResponseExtra,Boolean>>>> show = new ArrayList<>();

    //字段对应的type
    private List<Class<List<HandlerChain<ResponseExtra,List<MethodParam>>>>> returnType = new ArrayList<>();

    public List<Class<List<HandlerChain<ResponseExtra, String>>>> getDescription() {
        return description;
    }

    public void setDescription(List<Class<List<HandlerChain<ResponseExtra, String>>>> description) {
        this.description = description;
    }

    public List<Class<List<HandlerChain<ResponseExtra, Boolean>>>> getIgnore() {
        return ignore;
    }

    public void setIgnore(List<Class<List<HandlerChain<ResponseExtra, Boolean>>>> ignore) {
        this.ignore = ignore;
    }

    public List<Class<List<HandlerChain<ResponseExtra, String>>>> getMockTemplate() {
        return mockTemplate;
    }

    public void setMockTemplate(List<Class<List<HandlerChain<ResponseExtra, String>>>> mockTemplate) {
        this.mockTemplate = mockTemplate;
    }

    public List<Class<List<HandlerChain<ResponseExtra, Boolean>>>> getRequired() {
        return required;
    }

    public void setRequired(List<Class<List<HandlerChain<ResponseExtra, Boolean>>>> required) {
        this.required = required;
    }

    public List<Class<List<HandlerChain<ResponseExtra, Boolean>>>> getShow() {
        return show;
    }

    public void setShow(List<Class<List<HandlerChain<ResponseExtra, Boolean>>>> show) {
        this.show = show;
    }

    public List<Class<List<HandlerChain<ResponseExtra, List<MethodParam>>>>> getReturnType() {
        return returnType;
    }

    public void setReturnType(List<Class<List<HandlerChain<ResponseExtra, List<MethodParam>>>>> returnType) {
        this.returnType = returnType;
    }
}
