package cn.easyutil.easyapi.configuration.filter;

import cn.easyutil.easyapi.entity.common.BodyType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * 控制器解析
 */
@Component
@ConfigurationProperties(prefix = "easyapi.filter.interface")
public class EasyApiInterfaceReaderFilter {

    //请求体类型
    private List<Class<List<HandlerChain<InterfaceExtra, BodyType>>>> bodyType = new ArrayList<>();

    //搜索关键字
    private List<Class<List<HandlerChain<InterfaceExtra, List<String>>>>> search = new ArrayList<>();

    //接口描述
    private List<Class<List<HandlerChain<InterfaceExtra, String>>>> description = new ArrayList<>();

    //开启请求包装
    private List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> enableReqPackage = new ArrayList<>();

    //开启响应包装
    private List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> enableResPackage = new ArrayList<>();

    //忽略
    private List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> ignore = new ArrayList<>();

    //更新策略
    private List<Class<List<HandlerChain<InterfaceExtra, RenewType>>>> renewType = new ArrayList<>();

    //请求方法
    private List<Class<List<HandlerChain<InterfaceExtra, RequestMethod>>>> requestMethod = new ArrayList<>();

    //请求参数说明
    private List<Class<List<HandlerChain<InterfaceExtra, String>>>> requestNote = new ArrayList<>();

    //请求路径
    private List<Class<List<HandlerChain<InterfaceExtra, String>>>> url = new ArrayList<>();

    //响应参数说明
    private List<Class<List<HandlerChain<InterfaceExtra, String>>>> responseNote = new ArrayList<>();

    //扫描接口
    private List<Class<List<HandlerChain<InterfaceExtra, List<Method>>>>> scan = new ArrayList<>();

    //是否显示
    private List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> show = new ArrayList<>();

    //接口名字
    private List<Class<List<HandlerChain<InterfaceExtra, String>>>> name = new ArrayList<>();

    //接口唯一标识
    private List<Class<List<HandlerChain<InterfaceExtra, String>>>> unique = new ArrayList<>();

    //模拟请求时的校验
    private List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> verifyMockTag = new ArrayList<>();

    public List<Class<List<HandlerChain<InterfaceExtra, BodyType>>>> getBodyType() {
        return bodyType;
    }

    public void setBodyType(List<Class<List<HandlerChain<InterfaceExtra, BodyType>>>> bodyType) {
        this.bodyType = bodyType;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, List<String>>>>> getSearch() {
        return search;
    }

    public void setSearch(List<Class<List<HandlerChain<InterfaceExtra, List<String>>>>> search) {
        this.search = search;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, String>>>> getDescription() {
        return description;
    }

    public void setDescription(List<Class<List<HandlerChain<InterfaceExtra, String>>>> description) {
        this.description = description;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> getEnableReqPackage() {
        return enableReqPackage;
    }

    public void setEnableReqPackage(List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> enableReqPackage) {
        this.enableReqPackage = enableReqPackage;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> getEnableResPackage() {
        return enableResPackage;
    }

    public void setEnableResPackage(List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> enableResPackage) {
        this.enableResPackage = enableResPackage;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> getIgnore() {
        return ignore;
    }

    public void setIgnore(List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> ignore) {
        this.ignore = ignore;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, RenewType>>>> getRenewType() {
        return renewType;
    }

    public void setRenewType(List<Class<List<HandlerChain<InterfaceExtra, RenewType>>>> renewType) {
        this.renewType = renewType;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, RequestMethod>>>> getRequestMethod() {
        return requestMethod;
    }

    public void setRequestMethod(List<Class<List<HandlerChain<InterfaceExtra, RequestMethod>>>> requestMethod) {
        this.requestMethod = requestMethod;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, String>>>> getRequestNote() {
        return requestNote;
    }

    public void setRequestNote(List<Class<List<HandlerChain<InterfaceExtra, String>>>> requestNote) {
        this.requestNote = requestNote;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, String>>>> getUrl() {
        return url;
    }

    public void setUrl(List<Class<List<HandlerChain<InterfaceExtra, String>>>> url) {
        this.url = url;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, String>>>> getResponseNote() {
        return responseNote;
    }

    public void setResponseNote(List<Class<List<HandlerChain<InterfaceExtra, String>>>> responseNote) {
        this.responseNote = responseNote;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, List<Method>>>>> getScan() {
        return scan;
    }

    public void setScan(List<Class<List<HandlerChain<InterfaceExtra, List<Method>>>>> scan) {
        this.scan = scan;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> getShow() {
        return show;
    }

    public void setShow(List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> show) {
        this.show = show;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, String>>>> getName() {
        return name;
    }

    public void setName(List<Class<List<HandlerChain<InterfaceExtra, String>>>> name) {
        this.name = name;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, String>>>> getUnique() {
        return unique;
    }

    public void setUnique(List<Class<List<HandlerChain<InterfaceExtra, String>>>> unique) {
        this.unique = unique;
    }

    public List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> getVerifyMockTag() {
        return verifyMockTag;
    }

    public void setVerifyMockTag(List<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> verifyMockTag) {
        this.verifyMockTag = verifyMockTag;
    }
}
