package cn.easyutil.easyapi.configuration;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * 全局响应配置
 */
@Component
@ConfigurationProperties(prefix = "easyapi.global.response")
public class EasyApiGlobalResponseConfiguration {

    //是否开启全局配置
    private boolean enable = false;

    /** 全局统一接口返回类型*/
    private Class<?> returnType;

    /** 全局统一接口返回类型的字段*/
    private String fieldName;

    /** 全局统一接口返回类型需要被忽略的字段*/
    private Set<String> ignoreFields = new HashSet<>();

    /**
     * 包含的方法名表达式,例如:cn.easyutil.**.test(**
     */
    private Set<String> includeMethods = new HashSet<>(Collections.singletonList("**.**"));

    /**
     * 不包含的方法名表达式,例如:cn.easyutil.**.test**
     */
    private Set<String> excludeMethods = new HashSet<>();

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public Class<?> getReturnType() {
        return returnType;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Set<String> getIgnoreFields() {
        return ignoreFields;
    }

    public void setIgnoreFields(Set<String> ignoreFields) {
        this.ignoreFields = ignoreFields;
    }

    public Set<String> getIncludeMethods() {
        return includeMethods;
    }

    public void setIncludeMethods(Set<String> includeMethods) {
        this.includeMethods = includeMethods;
    }

    public Set<String> getExcludeMethods() {
        return excludeMethods;
    }

    public void setExcludeMethods(Set<String> excludeMethods) {
        this.excludeMethods = excludeMethods;
    }
}
