package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.File;
import java.util.*;

@Component
@ConfigurationProperties(prefix = "easyapi")
public class EasyApiBaseConfiguration {

    /** 是否开启接口文档*/
    private boolean enable = false;

    /** 启动时是否重新扫描接口文档 */
    private boolean rescan = true;

    /** 是否打印sql日志*/
    private boolean showSql = false;

    /** 是否显示logo*/
    private boolean showBanner = true;

    /** 启动时更新已存在的文档*/
    private boolean renewDoc = true;

    /** 启动时删除接口文档信息，保留其他数据 */
    private boolean dropDoc = false;

    /** 启动时删除全部用户相关的数据*/
    private boolean dropUsers = false;

    /** 启动时删除公共配置*/
    private boolean dropGlobalSetting = false;

    /** 启动时删除历史全部信息*/
    private boolean dropAll = false;

    /** 允许使用该key进行文档同步*/
    private String syncSecret;

    /** 项目唯一标识*/
    private String unique;

    /** 项目名称 */
    private String projectName;

    /** 项目源码路径*/
    private Set<String> projectSourcePaths = new HashSet<>();

    /** 扫描包路径*/
    private Set<String> scanPackages = new HashSet<>(Collections.singletonList("**/**"));

    /** 数组生成mock的长度*/
    private int mockArraySize = 12;

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isRescan() {
        return rescan;
    }

    public void setRescan(boolean rescan) {
        this.rescan = rescan;
    }

    public boolean isDropDoc() {
        return dropDoc;
    }

    public void setDropDoc(boolean dropDoc) {
        this.dropDoc = dropDoc;
    }

    public boolean isDropAll() {
        return dropAll;
    }

    public boolean isDropUsers() {
        return dropUsers;
    }

    public void setDropUsers(boolean dropUsers) {
        this.dropUsers = dropUsers;
    }

    public boolean isDropGlobalSetting() {
        return dropGlobalSetting;
    }

    public void setDropGlobalSetting(boolean dropGlobalSetting) {
        this.dropGlobalSetting = dropGlobalSetting;
    }

    public Set<String> getProjectSourcePaths() {
        return projectSourcePaths;
    }

    public void setProjectSourcePaths(Set<String> projectSourcePaths) {
        this.projectSourcePaths = projectSourcePaths;
    }

    public boolean isRenewDoc() {
        return renewDoc;
    }

    public void setRenewDoc(boolean renewDoc) {
        this.renewDoc = renewDoc;
    }

    public void setDropAll(boolean dropAll) {
        this.dropAll = dropAll;
    }

    public Set<String> getScanPackages() {
        return scanPackages;
    }

    public void setScanPackages(Set<String> scanPackages) {
        this.scanPackages = scanPackages;
    }

    public int getMockArraySize() {
        return mockArraySize;
    }

    public void setMockArraySize(int mockArraySize) {
        this.mockArraySize = mockArraySize;
    }

    public String getSyncSecret() {
        if(StringUtil.isEmpty(syncSecret)){
            syncSecret = getUnique();
        }
        return syncSecret;
    }

    public void setSyncSecret(String syncSecret) {
        this.syncSecret = syncSecret;
    }

    public String getUnique() {
        if(!StringUtil.isEmpty(unique)){
            return unique;
        }
        this.setUnique(UUID.randomUUID().toString().replace("-","").substring(0,16));
        StackTraceElement[] stackTrace = new RuntimeException().getStackTrace();
        for (StackTraceElement stackTraceElement : stackTrace) {
            if ("main".equals(stackTraceElement.getMethodName())) {
                this.setUnique(StringUtil.toMD5(stackTraceElement.getClassName()).substring(0,16));
                break;
            }
        }
        return unique;
    }

    public void setUnique(String unique) {
        this.unique = unique;
    }

    public String getProjectName() {
        if(!StringUtil.isEmpty(this.projectName)){
            return projectName;
        }
        return System.getProperty("user.dir").substring(System.getProperty("user.dir").lastIndexOf(File.separator)+1);
    }

    @Value("${spring.application.name:}")
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public boolean isShowSql() {
        return showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public boolean isShowBanner() {
        return showBanner;
    }

    public void setShowBanner(boolean showBanner) {
        this.showBanner = showBanner;
    }
}
