/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.run;

import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiBaseConfiguration;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.doc.DBParamEntity;
import cn.easyutil.easyapi.filter.ApiCreateStep;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.operator.ReadBeanOperator;
import cn.easyutil.easyapi.filter.operator.ReadControllerOperator;
import cn.easyutil.easyapi.filter.operator.ReadInterfaceOperator;
import cn.easyutil.easyapi.filter.operator.ReadMockTemplateOperator;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceReader;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.javadoc.reader.SourceParameterComment;
import cn.easyutil.easyapi.logic.creator.ControllerCreator;
import cn.easyutil.easyapi.logic.creator.InterfaceCreator;
import cn.easyutil.easyapi.logic.creator.JavaBeanCreator;
import cn.easyutil.easyapi.logic.creator.MethodParamsCreator;
import cn.easyutil.easyapi.logic.run.DocClassBean;
import cn.easyutil.easyapi.logic.run.DocInterfaceBean;
import cn.easyutil.easyapi.mybatis.service.ControllerService;
import cn.easyutil.easyapi.mybatis.service.InterfaceParamService;
import cn.easyutil.easyapi.mybatis.service.InterfaceService;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;

public class DocCreate {
    private final AllConfiguration all;
    private final ApplicationContext appContext;
    private final InterfaceService interfaceService = new InterfaceService();
    private final ControllerService controllerService = new ControllerService();
    private final InterfaceParamService interfaceParamService = new InterfaceParamService();

    public DocCreate(AllConfiguration all, ApplicationContext appContext) {
        this.all = all;
        this.appContext = appContext;
    }

    public void createApi() {
        EasyApiBaseConfiguration configuration = ProjectContext.allConfiguration.getConfiguration();
        ReadControllerOperator controllerOperator = ProjectContext.controllerOperator;
        Set<Class> set = controllerOperator.readControllers(this.appContext);
        if (set == null || set.isEmpty()) {
            return;
        }
        if (configuration.isRenewDoc()) {
            DBModuleInterfaceEntity upgrade = new DBModuleInterfaceEntity();
            upgrade.setUpgradeStatus(1);
            this.interfaceService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DBModuleInterfaceEntity.class).set(DBModuleInterfaceEntity::getUpgradeStatus, (Object)1)).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId));
        }
        for (Class aClass : set) {
            List<DocInterfaceBean> interfaces;
            DocClassBean api = this.createControllerApi(aClass);
            DBModuleControllerEntity controllerBean = api.getController();
            if (controllerBean == null) continue;
            DBModuleControllerEntity queryController = (DBModuleControllerEntity)this.controllerService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DBModuleControllerEntity.class).eq(BaseDbEntity::getProjectId, (Object)controllerBean.getProjectId())).eq(DBModuleControllerEntity::getClassName, (Object)controllerBean.getClassName()), false);
            if (queryController == null) {
                controllerBean.setCreateTime(System.currentTimeMillis());
                controllerBean.setUpdateTime(System.currentTimeMillis());
                this.controllerService.save(controllerBean);
                queryController = controllerBean;
            } else {
                Long id = queryController.getId();
                BeanUtils.copyProperties((Object)controllerBean, (Object)queryController);
                queryController.setId(id);
                this.controllerService.updateById(queryController);
            }
            if ((interfaces = api.getInterfaces()) == null || interfaces.isEmpty()) continue;
            DBModuleInterfaceEntity queryInterface = new DBModuleInterfaceEntity();
            queryInterface.setProjectId(ProjectContext.currentProjectId);
            queryInterface.setControllerId(queryController.getId());
            ArrayList apiInterfaceBeans = this.interfaceService.list((Wrapper)Wrappers.lambdaQuery((Object)queryInterface));
            if (apiInterfaceBeans == null) {
                apiInterfaceBeans = new ArrayList();
            }
            Map allExistInterface = apiInterfaceBeans.stream().collect(Collectors.toMap(DBModuleInterfaceEntity::getInterfaceUnique, Function.identity()));
            for (DocInterfaceBean itf : interfaces) {
                List<DocParamEntity> nowParams;
                List<DocParamEntity> oldParams;
                DBModuleInterfaceEntity interfaceBean = itf.getInterfaceBean();
                DBInterfaceParamEntity requestParam = itf.getRequestParam();
                DBModuleInterfaceEntity dbFindInterface = (DBModuleInterfaceEntity)allExistInterface.get(interfaceBean.getInterfaceUnique());
                if (dbFindInterface != null && !dbFindInterface.getShowType().equals(interfaceBean.getShowType())) {
                    dbFindInterface.setShowType(interfaceBean.getShowType());
                    this.interfaceService.updateById(dbFindInterface);
                }
                if (dbFindInterface != null && dbFindInterface.getUpgradeStatus() == 0) continue;
                interfaceBean.setControllerId(queryController.getId());
                interfaceBean.setProjectId(queryController.getProjectId());
                if (interfaceBean.getUpgradeStatus() == null) {
                    interfaceBean.setUpgradeStatus(0);
                }
                if (dbFindInterface != null) {
                    interfaceBean.setId(dbFindInterface.getId());
                    interfaceBean.setUpgradeStatus(0);
                    if (interfaceBean.getRenewType().equals(RenewType.skip.getType())) continue;
                    if (interfaceBean.getRenewType().equals(RenewType.increment.getType())) {
                        interfaceBean.mergin(dbFindInterface);
                    }
                    if (StringUtil.isEmpty(dbFindInterface.getOrigin())) {
                        interfaceBean.createOrigin();
                    } else {
                        interfaceBean.setOrigin(dbFindInterface.getOrigin());
                    }
                    this.interfaceService.updateById(interfaceBean);
                } else {
                    this.interfaceService.save(interfaceBean);
                }
                allExistInterface.put(interfaceBean.getInterfaceUnique(), interfaceBean);
                DBInterfaceParamEntity old = (DBInterfaceParamEntity)this.interfaceParamService.getOne((Wrapper)Wrappers.lambdaQuery(DBInterfaceParamEntity.class).eq(DBInterfaceParamEntity::getInterfaceId, (Object)interfaceBean.getId()), false);
                requestParam.setInterfaceId(interfaceBean.getId());
                requestParam.setProjectId(interfaceBean.getProjectId());
                if (old == null) {
                    this.interfaceParamService.save(requestParam);
                    continue;
                }
                if (!StringUtil.isEmpty(requestParam.getRequestParamJson()) && !StringUtil.isEmpty(old.getRequestParamJson())) {
                    oldParams = JsonUtil.jsonToList(old.getRequestParamJson(), DocParamEntity.class);
                    nowParams = JsonUtil.jsonToList(requestParam.getRequestParamJson(), DocParamEntity.class);
                    this.paramsMergin(nowParams, oldParams.stream().collect(Collectors.toMap(DBParamEntity::getUnique, Function.identity())));
                    requestParam.setRequestParamJson(JsonUtil.beanToJson(nowParams));
                }
                if (!StringUtil.isEmpty(requestParam.getResponseParamJson()) && !StringUtil.isEmpty(old.getResponseParamJson())) {
                    oldParams = JsonUtil.jsonToList(old.getResponseParamJson(), DocParamEntity.class);
                    nowParams = JsonUtil.jsonToList(requestParam.getResponseParamJson(), DocParamEntity.class);
                    this.paramsMergin(nowParams, oldParams.stream().collect(Collectors.toMap(DBParamEntity::getUnique, Function.identity())));
                    requestParam.setResponseParamJson(JsonUtil.beanToJson(nowParams));
                }
                requestParam.setId(old.getId());
                this.interfaceParamService.updateById(requestParam);
            }
        }
    }

    private void paramsMergin(List<DocParamEntity> now, Map<String, DocParamEntity> old) {
        if (now == null || now.isEmpty()) {
            return;
        }
        for (DocParamEntity nowParam : now) {
            DocParamEntity oldParam = old.get(nowParam.getUnique());
            if (oldParam != null && !StringUtil.isEmpty(oldParam.getOrigin())) {
                DocParamEntity origin = JsonUtil.jsonToBean(oldParam.getOrigin(), DocParamEntity.class);
                this.paramsMergin(nowParam, oldParam, origin);
                nowParam.setOrigin(JsonUtil.beanToJson(origin));
            }
            if (nowParam.getChildren() == null || nowParam.getChildren().isEmpty()) continue;
            this.paramsMergin(nowParam.getChildren(), old);
        }
    }

    private void paramsMergin(DocParamEntity now, DocParamEntity old, DocParamEntity origin) {
        if (now.getRenewType().equals(RenewType.skip.getType())) {
            BeanUtils.copyProperties((Object)old, (Object)now);
            return;
        }
        if (now.getRenewType().equals(RenewType.overwrite.getType())) {
            return;
        }
        EasyapiOriginUtil.mergin(now, old, origin);
    }

    public DocClassBean createControllerApi(Class aClass) {
        String path;
        String controllerPath;
        String canonicalName = aClass.getCanonicalName();
        File controllerFile = null;
        Iterator<String> iterator = ProjectContext.projectBasePath.iterator();
        while (iterator.hasNext() && !(controllerFile = new File(controllerPath = (path = iterator.next()) + File.separator + aClass.getCanonicalName().replace(".", File.separator) + ".java")).exists()) {
        }
        JavaSourceReader controllerSourceReader = new JavaSourceReader();
        if (controllerFile != null && controllerFile.exists()) {
            controllerSourceReader = JavaSourceReader.builder(controllerFile);
        }
        ApiExtra extra = new ApiExtra();
        extra.setControllerClass(aClass);
        extra.setControllerComment(controllerSourceReader.getComment());
        if (!StringUtil.isEmpty(this.all.getConfiguration().getScanPackage()) && !canonicalName.startsWith(this.all.getConfiguration().getScanPackage())) {
            return DocClassBean.EMPTY;
        }
        ReadControllerOperator controllerOperator = ProjectContext.controllerOperator;
        if (controllerOperator.ignore(aClass, extra).booleanValue()) {
            return DocClassBean.EMPTY;
        }
        DocClassBean result = new DocClassBean();
        DBModuleControllerEntity controllerBean = ControllerCreator.builder(aClass).setFilter(controllerOperator).setExtra(extra).buildController();
        controllerBean.setProjectId(ProjectContext.currentProjectId);
        controllerBean.setModuleId(ProjectContext.currentModuleId);
        result.setController(controllerBean);
        extra.setDbController(controllerBean);
        extra.setStep(ApiCreateStep.Controller);
        ReadInterfaceOperator interfaceOperator = ProjectContext.interfaceOperator;
        List<Method> methods = interfaceOperator.readAllInterfaces(aClass, extra);
        List<MethodComment> methodComment = controllerSourceReader.getComment().getMethods();
        HashMap readMethodParamComment = new HashMap();
        for (MethodComment comment : methodComment) {
            List<SourceParameterComment> parameters = comment.getParameters();
            HashMap<String, String> map = new HashMap<String, String>();
            for (SourceParameterComment parameter : parameters) {
                map.put(parameter.getName(), parameter.getComment());
            }
            readMethodParamComment.put(comment.getName(), map);
        }
        for (Method method : methods) {
            if (interfaceOperator.ignore(method, extra).booleanValue()) continue;
            MethodComment methodSourceComment = controllerSourceReader.getComment().getMethod(method.getName());
            extra.setMethod(method);
            extra.setMethodComment(methodSourceComment);
            extra.setStep(ApiCreateStep.Interface);
            DBModuleInterfaceEntity interfaceBean = InterfaceCreator.builder(method).setFilter(interfaceOperator).setApiExtra(extra).buildInterface();
            interfaceBean.setProjectId(controllerBean.getProjectId());
            interfaceBean.setModuleId(controllerBean.getModuleId());
            interfaceBean.setControllerClass(controllerBean.getClassName());
            interfaceBean.setControllerId(controllerBean.getId());
            extra.setDbInterface(interfaceBean);
            List<String> customSearch = interfaceOperator.customSearch(method, extra);
            interfaceBean.setCustomTags(customSearch == null ? "" : String.join((CharSequence)",", customSearch));
            if (!StringUtil.isEmpty(interfaceBean.getCustomTags()) && interfaceBean.getCustomTags().length() > 150) {
                interfaceBean.setCustomTags(interfaceBean.getCustomTags().substring(0, 150));
            }
            interfaceBean.setSearchTags(DBModuleInterfaceEntity.buildSearchTag(interfaceBean));
            DocInterfaceBean docInterfaceBean = new DocInterfaceBean();
            docInterfaceBean.setInterfaceBean(interfaceBean);
            ReadBeanOperator beanOperator = ProjectContext.beanOperator;
            ReadMockTemplateOperator mockOperator = ProjectContext.mockTemplateOperator;
            MethodParamsCreator methodParamsCreator = MethodParamsCreator.build(aClass, method).withBeanCreator(JavaBeanCreator.builder(beanOperator, ProjectContext.projectBasePath, mockOperator, extra)).withMockFilter(mockOperator).withReqFilter(ProjectContext.requestOperator).withResFilter(ProjectContext.responseOperator).withBeanFilter(beanOperator).withExtra(extra).create();
            String requestParams = JsonUtil.beanToJson(methodParamsCreator.getRequestParameters());
            DBInterfaceParamEntity reqPram = new DBInterfaceParamEntity();
            reqPram.setProjectId(ProjectContext.currentProjectId);
            reqPram.setProjectId(ProjectContext.currentProjectId);
            reqPram.setInterfaceId(interfaceBean.getId());
            reqPram.setCreateTime(System.currentTimeMillis());
            reqPram.setUpdateTime(System.currentTimeMillis());
            reqPram.setRequestParamJson(requestParams);
            reqPram.setResponseParamJson(JsonUtil.beanToJson(methodParamsCreator.getReturnParameter()));
            reqPram.setResponseMock(methodParamsCreator.getResponseMock());
            reqPram.setRequestMock(methodParamsCreator.getRequestMock());
            docInterfaceBean.setRequestParam(reqPram);
            result.getInterfaces().add(docInterfaceBean);
        }
        return result;
    }
}

