/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.operator.ReadInterfaceOperator;
import cn.easyutil.easyapi.logic.creator.ApiCreator;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Method;

public class InterfaceCreator
implements ApiCreator {
    private Method method;
    private DBModuleInterfaceEntity interfaceBean;
    private ReadInterfaceOperator filter = new ReadInterfaceOperator(null);
    private ApiExtra extra;

    private InterfaceCreator() {
    }

    public static InterfaceCreator builder(Method method) {
        InterfaceCreator creator = new InterfaceCreator();
        creator.method = method;
        return creator;
    }

    public InterfaceCreator setFilter(ReadInterfaceOperator filter) {
        if (filter == null) {
            return this;
        }
        this.filter = filter;
        return this;
    }

    public DBModuleInterfaceEntity buildInterface() {
        if (this.interfaceBean != null) {
            return this.interfaceBean;
        }
        try {
            this.create();
        }
        catch (Exception e) {
            System.out.println("\u521b\u5efa\u63a5\u53e3:" + this.method.toGenericString() + "\u5931\u8d25,\u539f\u56e0:" + e.getMessage());
            e.printStackTrace();
        }
        return this.interfaceBean;
    }

    private void create() {
        this.interfaceBean = new DBModuleInterfaceEntity();
        this.interfaceBean.setShowName(this.filter.showName(this.method, this.extra));
        this.interfaceBean.setShowType(this.filter.show(this.method, this.extra) != false ? 1 : 0);
        this.interfaceBean.setShowName(this.interfaceBean.getShowName().trim());
        this.interfaceBean.setMethodName(this.method.getName());
        this.interfaceBean.setDescription(this.filter.description(this.method, this.extra).trim());
        this.interfaceBean.setRequestMethod(this.filter.requestMethod(this.method, this.extra));
        RenewType renewType = this.filter.renewType(this.method, this.extra);
        this.interfaceBean.setRenewType(renewType == null ? RenewType.increment.getType() : renewType.getType());
        this.interfaceBean.setBodyType(this.filter.bodyType(this.method, this.extra).getType());
        this.interfaceBean.setPinyin(StringUtil.toPinYin(this.interfaceBean.getShowName()).trim());
        this.interfaceBean.setSource(this.extra.getMethodComment().getSource());
        this.interfaceBean.setCreateTime(System.currentTimeMillis());
        this.interfaceBean.setUpdateTime(System.currentTimeMillis());
        this.interfaceBean.setInterfaceUnique(StringUtil.toMD5(ProjectContext.currentProjectName + this.filter.unique(this.method, this.extra)));
        this.interfaceBean.setEnableReqPackage(this.filter.enableReqPackage(this.method, this.extra) != false ? 1 : 0);
        this.interfaceBean.setEnableResPackage(this.filter.enableResPackage(this.method, this.extra) != false ? 1 : 0);
        this.interfaceBean.setRequestUrl(this.filter.requestUrl(this.method, this.extra));
    }

    @Override
    public InterfaceCreator setApiExtra(ApiExtra extra) {
        this.extra = extra;
        return this;
    }
}

