/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi;

import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiBaseConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiDataConfiguration;
import cn.easyutil.easyapi.content.AuthModuleButtonsEnum;
import cn.easyutil.easyapi.content.DBTableClassify;
import cn.easyutil.easyapi.content.DBTables;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.auth.AuthMoudle;
import cn.easyutil.easyapi.entity.db.auth.DBDictEntity;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleAuthEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHostEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.filter.operator.ReadBeanOperator;
import cn.easyutil.easyapi.filter.operator.ReadControllerOperator;
import cn.easyutil.easyapi.filter.operator.ReadInterfaceOperator;
import cn.easyutil.easyapi.filter.operator.ReadMockTemplateOperator;
import cn.easyutil.easyapi.filter.operator.ReadRequestOperator;
import cn.easyutil.easyapi.filter.operator.ReadResponseOperator;
import cn.easyutil.easyapi.interview.dto.OpenSyncDto;
import cn.easyutil.easyapi.logic.creator.MethodParam;
import cn.easyutil.easyapi.logic.run.DocCreate;
import cn.easyutil.easyapi.logic.run.DocCreatePost;
import cn.easyutil.easyapi.logic.run.DocCreatePre;
import cn.easyutil.easyapi.mybatis.MybatisUtil;
import cn.easyutil.easyapi.mybatis.SqlExecMapper;
import cn.easyutil.easyapi.mybatis.service.ControllerService;
import cn.easyutil.easyapi.mybatis.service.DictService;
import cn.easyutil.easyapi.mybatis.service.HostService;
import cn.easyutil.easyapi.mybatis.service.InterfaceParamService;
import cn.easyutil.easyapi.mybatis.service.InterfaceService;
import cn.easyutil.easyapi.mybatis.service.ModuleService;
import cn.easyutil.easyapi.mybatis.service.ProjectService;
import cn.easyutil.easyapi.mybatis.service.RoleAuthService;
import cn.easyutil.easyapi.mybatis.service.RoleProjectService;
import cn.easyutil.easyapi.mybatis.service.RoleService;
import cn.easyutil.easyapi.mybatis.service.SimpleUnitService;
import cn.easyutil.easyapi.mybatis.service.UserService;
import cn.easyutil.easyapi.mybatis.service.UserTemporaryAuthService;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;

public class EasyapiRun {
    private static ProjectService projectService;
    private static UserService userService;
    private static DictService dictService;
    private static UserTemporaryAuthService userTemporaryAuthService;
    private static HostService hostService;
    private static ModuleService moduleService;
    private static AllConfiguration all;
    private static RoleService roleService;
    private static RoleAuthService roleAuthService;
    private static RoleProjectService roleProjectService;
    private static ControllerService controllerService;
    private static InterfaceService interfaceService;
    private static InterfaceParamService interfaceParamService;
    private static SimpleUnitService simpleUnitService;
    private static ApplicationContext appContext;

    public static void run(AllConfiguration all, ApplicationContext appContext) {
        EasyapiRun.all = all;
        EasyapiRun.appContext = appContext;
        EasyApiBaseConfiguration configuration = all.getConfiguration();
        configuration.getUnique();
        if (!configuration.isEnable()) {
            return;
        }
        try {
            EasyapiRun.initBase(all);
            EasyapiRun.initDataSource(all);
            projectService = new ProjectService();
            userService = new UserService();
            dictService = new DictService();
            userTemporaryAuthService = new UserTemporaryAuthService();
            hostService = new HostService();
            moduleService = new ModuleService();
            roleService = new RoleService();
            roleAuthService = new RoleAuthService();
            roleProjectService = new RoleProjectService();
            controllerService = new ControllerService();
            interfaceService = new InterfaceService();
            interfaceParamService = new InterfaceParamService();
            simpleUnitService = new SimpleUnitService();
            EasyapiRun.createDB();
            EasyapiRun.initProject();
            EasyapiRun.clearDB();
            DocCreatePre.build().pre();
            DocCreate instance = new DocCreate(all, appContext);
            if (configuration.isRescan()) {
                instance.createApi();
            }
            DocCreatePost.build(all, appContext).post();
            System.out.println("*********************************************");
            System.out.println("**********   \u63a5\u53e3\u6587\u6863\u5df2\u751f\u6210 url=/apidoc.html  ***************");
            System.out.println("*********************************************");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u63a5\u53e3\u6587\u6863\u751f\u6210\u5931\u8d25", e);
        }
    }

    private static void initBase(AllConfiguration all) {
        ProjectContext.allConfiguration = all;
        Set<String> projectSourcePaths = all.getConfiguration().getProjectSourcePaths();
        String filePost = File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
        if (projectSourcePaths.isEmpty()) {
            try {
                String path = new File("").getCanonicalPath();
                projectSourcePaths.add(path + filePost);
            }
            catch (IOException e) {
                throw new ApidocException(e);
            }
        }
        Iterator<String> iterator = projectSourcePaths.iterator();
        HashSet<String> copyPaths = new HashSet<String>();
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (!next.endsWith(File.separator)) {
                next = next + File.separator;
            }
            if (!next.endsWith(filePost)) {
                next = next + filePost;
            }
            copyPaths.add(next);
        }
        projectSourcePaths = copyPaths;
        ProjectContext.projectBasePath = projectSourcePaths;
        ProjectContext.controllerOperator = new ReadControllerOperator(ProjectContext.allConfiguration.getReadControllerConfig());
        ProjectContext.interfaceOperator = new ReadInterfaceOperator(ProjectContext.allConfiguration.getReadInterfaceConfig());
        ProjectContext.beanOperator = new ReadBeanOperator(ProjectContext.allConfiguration.getReadBeanConfig());
        ProjectContext.mockTemplateOperator = new ReadMockTemplateOperator(ProjectContext.allConfiguration.getReadMockTemplateConfig());
        ProjectContext.requestOperator = new ReadRequestOperator(ProjectContext.allConfiguration.getReadRequestConfig());
        ProjectContext.responseOperator = new ReadResponseOperator(ProjectContext.allConfiguration.getReadResponseConfig());
        EasyApiBaseConfiguration base = all.getConfiguration();
        if (base.getGlobalResponseClass() != null && !StringUtil.isEmpty(base.getGlobalResponseFieldName())) {
            Field[] fields;
            ProjectContext.globalFieldName = base.getGlobalResponseFieldName();
            ProjectContext.globalResponseIgnoreFieldNames = base.getGlobalResponseIgnoreFieldNames();
            Class<?> globalResponseClass = base.getGlobalResponseClass();
            ProjectContext.globalResponseClass = globalResponseClass;
            ArrayList<MethodParam> globalParams = new ArrayList<MethodParam>();
            for (Field field : fields = globalResponseClass.getDeclaredFields()) {
                MethodParam param = new MethodParam();
                param.setParamType(field.getGenericType());
                param.setParamName(field.getName());
                globalParams.add(param);
            }
            ProjectContext.globalParams = globalParams;
        }
    }

    private static void initDataSource(AllConfiguration all) {
        EasyApiBaseConfiguration configuration = all.getConfiguration();
        EasyApiDataConfiguration dataConfiguration = all.getDataConfiguration();
        if (StringUtil.isEmpty(dataConfiguration.getDriverClassName())) {
            dataConfiguration.setDriverClassName("org.h2.Driver");
        }
        if (StringUtil.isEmpty(dataConfiguration.getUrl())) {
            String dbFilePath = all.getDataConfiguration().getDbFilePath();
            if (dbFilePath.endsWith(File.separator)) {
                dbFilePath = dbFilePath.substring(0, dbFilePath.length() - 1);
            }
            dataConfiguration.setUrl("jdbc:h2:" + dbFilePath + "-easyapi;AUTO_SERVER=TRUE");
        }
        if (StringUtil.isEmpty(dataConfiguration.getUserName())) {
            dataConfiguration.setUserName("easyapi");
        }
        if (StringUtil.isEmpty(dataConfiguration.getPassword())) {
            dataConfiguration.setPassword("123456");
        }
        ArrayList<DBTables> mappersClasses = new ArrayList<DBTables>(Arrays.asList(DBTables.values()));
        mappersClasses.removeIf(table -> table.getMapper() == null);
        List<Class> collect = mappersClasses.stream().map(DBTables::getMapper).collect(Collectors.toList());
        Class[] mappers = new Class[collect.size()];
        collect.toArray(mappers);
        if (dataConfiguration.getDataSource() != null) {
            MybatisUtil.init(dataConfiguration.getDataSource(), mappers);
        } else {
            DataSource dataSource = EasyapiRun.dataSource(dataConfiguration.getUrl(), dataConfiguration.getDriverClassName(), dataConfiguration.getUserName(), dataConfiguration.getPassword());
            MybatisUtil.init(dataSource, mappers);
        }
    }

    private static void createDB() {
        SqlExecMapper mapper = MybatisUtil.getMapper(SqlExecMapper.class);
        for (DBTables table : DBTables.values()) {
            mapper.execUpdate(table.tableDDL());
            table.replenishField();
        }
    }

    private static void clearDB() {
        EasyApiBaseConfiguration configuration = all.getConfiguration();
        SqlExecMapper mapper = MybatisUtil.getMapper(SqlExecMapper.class);
        if (configuration.isDropAll()) {
            if (ProjectContext.currentProject.getDefaultStatus() == 1) {
                for (DBTables table : DBTables.values()) {
                    mapper.execUpdate(table.dropSql());
                }
            } else {
                controllerService.remove((Wrapper)Wrappers.lambdaQuery(DBModuleControllerEntity.class).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId));
                interfaceService.remove((Wrapper)Wrappers.lambdaQuery(DBModuleInterfaceEntity.class).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId));
                interfaceParamService.remove((Wrapper)Wrappers.lambdaQuery(DBInterfaceParamEntity.class).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId));
                simpleUnitService.remove((Wrapper)Wrappers.lambdaQuery(DBSimpleUnitEntity.class).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId));
            }
        }
        if (configuration.isDropUsers() && ProjectContext.currentProject.getDefaultStatus() == 1) {
            for (DBTables table : DBTables.getByClassify(DBTableClassify.user)) {
                mapper.execUpdate(table.clearSql());
            }
        }
        if (configuration.isDropGlobalSetting() && ProjectContext.currentProject.getDefaultStatus() == 1) {
            for (DBTables table : DBTables.getByClassify(DBTableClassify.global)) {
                mapper.execUpdate(table.clearSql());
            }
        }
        if (configuration.isDropDoc()) {
            if (ProjectContext.currentProject.getDefaultStatus() == 1) {
                for (DBTables table : DBTables.getByClassify(DBTableClassify.doc)) {
                    mapper.execUpdate(table.clearSql());
                }
            } else {
                controllerService.remove((Wrapper)Wrappers.lambdaQuery(DBModuleControllerEntity.class).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId));
                interfaceService.remove((Wrapper)Wrappers.lambdaQuery(DBModuleInterfaceEntity.class).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId));
                interfaceParamService.remove((Wrapper)Wrappers.lambdaQuery(DBInterfaceParamEntity.class).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId));
                simpleUnitService.remove((Wrapper)Wrappers.lambdaQuery(DBSimpleUnitEntity.class).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId));
            }
        }
    }

    private static DataSource dataSource(String url, String driverClassName, String username, String password) {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setUrl(url);
        druidDataSource.setUsername(username);
        druidDataSource.setPassword(password);
        druidDataSource.setDriverClassName(driverClassName);
        druidDataSource.setInitialSize(0);
        druidDataSource.setMaxActive(100);
        druidDataSource.setMaxWait(10000L);
        druidDataSource.setMinIdle(20);
        druidDataSource.setValidationQuery("Select  'x' from DUAL");
        druidDataSource.setTestOnBorrow(false);
        druidDataSource.setTestOnReturn(false);
        druidDataSource.setTestWhileIdle(true);
        druidDataSource.setTimeBetweenEvictionRunsMillis(60000L);
        druidDataSource.setMinEvictableIdleTimeMillis(25200000L);
        druidDataSource.setRemoveAbandoned(true);
        druidDataSource.setRemoveAbandonedTimeout(1800);
        druidDataSource.setLogAbandoned(true);
        return druidDataSource;
    }

    private static void initProject() {
        DBProjectEntity query = (DBProjectEntity)projectService.getOne((Wrapper)Wrappers.lambdaQuery(DBProjectEntity.class).eq(DBProjectEntity::getProjectUnique, (Object)all.getConfiguration().getUnique()));
        if (query != null) {
            ProjectContext.currentProjectId = query.getId();
            ProjectContext.currentProjectName = query.getProjectName();
            ProjectContext.currentProject = query;
            return;
        }
        int count = projectService.count();
        DBProjectEntity project = EasyapiRun.addDefaultProject(count > 0 ? 0 : 1);
        DBModuleEntity module = EasyapiRun.addDefaultModule(project);
        DBUserEntity admin = (DBUserEntity)userService.getOne((Wrapper)Wrappers.lambdaQuery(DBUserEntity.class).eq(DBUserEntity::getAccount, (Object)"admin"));
        if (admin == null) {
            EasyapiRun.addDefaultUsers(module);
        } else {
            admin.setAccount(all.getUserConfiguration().getAccount());
            admin.setPassword(StringUtil.toMD5(all.getUserConfiguration().getPassword()));
            userService.updateById(admin);
        }
        ProjectContext.currentProjectId = project.getId();
        ProjectContext.currentModuleId = module.getId();
        ProjectContext.currentProjectName = project.getProjectName();
        ProjectContext.currentModuleName = module.getName();
        ProjectContext.currentProject = project;
        DBDictEntity syncEnable = new DBDictEntity();
        syncEnable.setDictKey(DBDictEntity.syncStatusKey());
        syncEnable = (DBDictEntity)dictService.getOne((Wrapper)Wrappers.lambdaQuery((Object)syncEnable), false);
        if (syncEnable == null) {
            syncEnable = new DBDictEntity();
            syncEnable.setDictKey(DBDictEntity.syncStatusKey());
            syncEnable.setDictVal("0");
            dictService.save(syncEnable);
        }
        DBDictEntity syncInterfaces = new DBDictEntity();
        syncInterfaces.setDictKey(DBDictEntity.syncInterfacesKey());
        syncInterfaces = (DBDictEntity)dictService.getOne((Wrapper)Wrappers.lambdaQuery((Object)syncInterfaces), false);
        if (syncInterfaces == null) {
            syncInterfaces = new DBDictEntity();
            syncInterfaces.setDictKey(DBDictEntity.syncInterfacesKey());
            syncInterfaces.setDictVal("[]");
            dictService.save(syncInterfaces);
        }
        DBDictEntity syncInfo = new DBDictEntity();
        syncInfo.setDictKey(DBDictEntity.syncInfoKey());
        syncInfo = (DBDictEntity)dictService.getOne((Wrapper)Wrappers.lambdaQuery((Object)syncInfo), false);
        if (syncInfo == null) {
            syncInfo = new DBDictEntity();
            syncInfo.setDictKey(DBDictEntity.syncInfoKey());
            syncInfo.setDictVal(JsonUtil.beanToJson(new OpenSyncDto()));
            dictService.save(syncInfo);
        }
        DBDictEntity syncSecret = new DBDictEntity();
        syncSecret.setDictKey(DBDictEntity.syncSecretKey());
        syncSecret = (DBDictEntity)dictService.getOne((Wrapper)Wrappers.lambdaQuery((Object)syncSecret), false);
        if (syncSecret == null) {
            syncSecret = new DBDictEntity();
            syncSecret.setDictKey(DBDictEntity.syncSecretKey());
            syncSecret.setDictVal(all.getConfiguration().getSyncSecret());
            dictService.save(syncSecret);
        }
        all.getConfiguration().setSyncSecret(syncSecret.getDictVal());
        all.getConfiguration().setUnique(project.getProjectUnique());
    }

    private static DBProjectEntity addDefaultProject(Integer defaultStatus) {
        DBProjectEntity project = new DBProjectEntity();
        project.setDefaultStatus(defaultStatus);
        project.setTitle(all.getConfiguration().getProjectName());
        project.setProjectName(all.getConfiguration().getProjectName());
        project.setProjectUnique(all.getConfiguration().getUnique());
        project.setAppSecret(all.getConfiguration().getSyncSecret());
        projectService.save(project);
        return project;
    }

    private static void addDefaultUsers(DBModuleEntity module) {
        DBUserEntity user = new DBUserEntity();
        user.setAccount(all.getUserConfiguration().getAccount());
        user.setPassword(StringUtil.toMD5(all.getUserConfiguration().getPassword()));
        user.setDisable(0);
        user.setDescription("\u8d85\u7ea7\u7ba1\u7406\u5458");
        user.setNickName("\u8d85\u7ea7\u7ba1\u7406\u5458");
        user.setSuperAdminStatus(1);
        user.setRoleId(0L);
        user.setHidden(1);
        user.setProjectId(module.getProjectId());
        user.setCreateTime(System.currentTimeMillis());
        user.setUpdateTime(System.currentTimeMillis());
        userService.save(user);
        userTemporaryAuthService.binds(user, Stream.of(AuthModuleButtonsEnum.values()).map(AuthModuleButtonsEnum::getCode).collect(Collectors.toList()));
        DBUserEntity hiddenUser = new DBUserEntity();
        hiddenUser.setAccount("remote");
        hiddenUser.setPassword(StringUtil.toMD5("remote"));
        hiddenUser.setSuperAdminStatus(1);
        hiddenUser.setRoleId(0L);
        hiddenUser.setHidden(1);
        hiddenUser.setProjectId(module.getProjectId());
        hiddenUser.setCreateTime(System.currentTimeMillis());
        hiddenUser.setUpdateTime(System.currentTimeMillis());
        userService.save(hiddenUser);
        DBRoleEntity testRole = new DBRoleEntity();
        testRole.setRoleName("\u6d4b\u8bd5\u4eba\u5458");
        testRole.setDescription("\u4ec5\u63d0\u4f9b\u6d4b\u8bd5\u76f8\u5173\u7684\u6743\u9650");
        testRole.setSuperAdminStatus(0);
        testRole.setProjectId(module.getProjectId());
        testRole.setCreateTime(System.currentTimeMillis());
        testRole.setUpdateTime(System.currentTimeMillis());
        roleService.save(testRole);
        DBRoleProjectEntity roleProject = new DBRoleProjectEntity();
        roleProject.setRoleId(testRole.getId());
        roleProject.setProjectId(module.getProjectId());
        roleProject.setCreateTime(System.currentTimeMillis());
        roleProject.setUpdateTime(System.currentTimeMillis());
        roleProjectService.save(roleProject);
        List<Integer> defaultAuthCodes = AuthMoudle.getDefaultAuthCodes();
        ArrayList<DBRoleAuthEntity> auths = new ArrayList<DBRoleAuthEntity>();
        for (Integer code : defaultAuthCodes) {
            DBRoleAuthEntity entity = new DBRoleAuthEntity();
            entity.setRoleId(testRole.getId());
            entity.setAuthCode(code);
            entity.setModuleId(module.getId());
            entity.setProjectId(module.getProjectId());
            entity.setCreateTime(System.currentTimeMillis());
            entity.setUpdateTime(System.currentTimeMillis());
            auths.add(entity);
        }
        roleAuthService.saveBatch(auths);
        DBUserEntity test = new DBUserEntity();
        test.setAccount("test");
        test.setPassword(StringUtil.toMD5("test"));
        test.setSuperAdminStatus(0);
        test.setProjectId(module.getProjectId());
        test.setRoleId(testRole.getId());
        test.setNickName("\u6d4b\u8bd5\u8d26\u53f7");
        test.setDescription("\u6d4b\u8bd5\u4eba\u5458\u8d26\u53f7");
        test.setDisable(0);
        userService.save(test);
        userTemporaryAuthService.binds(test, Stream.of(AuthModuleButtonsEnum.values()).filter(item -> item.getDefaultStatus() == 1).map(AuthModuleButtonsEnum::getCode).collect(Collectors.toList()));
    }

    private static DBModuleEntity addDefaultModule(DBProjectEntity project) {
        DBModuleEntity module = new DBModuleEntity();
        module.setProjectId(project.getId());
        module.setName("\u9ed8\u8ba4\u6a21\u5757");
        module.setDescription("\u521d\u59cb\u5316\u9879\u76ee\u6a21\u5757");
        module.setOutPackgeStatus(0);
        module.setDefaultStatus(project.getDefaultStatus());
        moduleService.save(module);
        if (project.getDefaultStatus() == 0) {
            return module;
        }
        DBModuleHostEntity mock = new DBModuleHostEntity();
        mock.setModuleId(module.getId());
        mock.setProjectId(project.getId());
        mock.setName("mock");
        mock.setDescription("mock\u8bf7\u6c42,\u8fd4\u56demock\u7ed3\u679c");
        mock.setDefaultStatus(project.getDefaultStatus());
        mock.setDisable(0);
        mock.setCanDelete(0);
        String port = appContext.getEnvironment().getProperty("server.port");
        port = port == null ? "8080" : port;
        mock.setHost("mock");
        hostService.save(mock);
        DBModuleHostEntity local = new DBModuleHostEntity();
        local.setProjectId(project.getId());
        local.setModuleId(module.getId());
        local.setName("\u672c\u5730\u73af\u5883");
        local.setDescription("\u672c\u673a\u73af\u5883");
        local.setDefaultStatus(0);
        local.setDisable(0);
        mock.setCanDelete(1);
        String address = "localhost";
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        local.setHost("http://" + address + ":" + port);
        hostService.save(local);
        return module;
    }
}

