package cn.easyutil.easyapi.logic.run;

import cn.easyutil.easyapi.configuration.*;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.entity.db.doc.*;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.filter.ApiCreateStep;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.operator.*;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceReader;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.javadoc.reader.SourceParameterComment;
import cn.easyutil.easyapi.logic.creator.*;
import cn.easyutil.easyapi.mybatis.service.ControllerService;
import cn.easyutil.easyapi.mybatis.service.InterfaceParamService;
import cn.easyutil.easyapi.mybatis.service.InterfaceService;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;

import java.io.File;
import java.lang.reflect.Method;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DocCreate {

    /**
     * 项目配置文件
     */

    private final AllConfiguration all;

    private final ApplicationContext appContext;

    private final InterfaceService interfaceService = new InterfaceService();

    private final ControllerService controllerService = new ControllerService();

    private final InterfaceParamService interfaceParamService = new InterfaceParamService();

    public DocCreate(AllConfiguration all, ApplicationContext appContext){
        this.all = all;
        this.appContext = appContext;
    }

    public void createApi() {
        EasyApiBaseConfiguration configuration = ProjectContext.allConfiguration.getConfiguration();
        ReadControllerOperator controllerOperator = ProjectContext.controllerOperator;
        Set<Class> set = controllerOperator.readControllers(appContext);
        if (set == null || set.isEmpty()) {
            return;
        }
        if(configuration.isRenewDoc()){
            //更新现有文档，把当前文档全部改成待更新
            DBModuleInterfaceEntity upgrade = new DBModuleInterfaceEntity();
            upgrade.setUpgradeStatus(1);
            interfaceService.update(
                    Wrappers.lambdaUpdate(DBModuleInterfaceEntity.class)
                    .set(DBModuleInterfaceEntity::getUpgradeStatus,1)
                    .eq(DBModuleInterfaceEntity::getProjectId,ProjectContext.currentProjectId));
        }
        Iterator<Class> iterator = set.iterator();
        //解析全部接口
        while (iterator.hasNext()) {
            Class aClass = iterator.next();
            //已生成的接口
            DocClassBean api = createControllerApi(aClass);
            DBModuleControllerEntity controllerBean = api.getController();
            if(controllerBean == null){
                continue;
            }
            //如果数据库中不存在则添加到数据库
            DBModuleControllerEntity queryController = controllerService.getOne(
                    Wrappers.lambdaQuery(DBModuleControllerEntity.class)
                    .eq(DBModuleControllerEntity::getProjectId, controllerBean.getProjectId())
                    .eq(DBModuleControllerEntity::getClassName, controllerBean.getClassName())
            ,false);
            if(queryController == null){
                controllerBean.setCreateTime(System.currentTimeMillis());
                controllerBean.setUpdateTime(System.currentTimeMillis());
                controllerService.save(controllerBean);
                queryController = controllerBean;
            }else{
                Long id = queryController.getId();
                BeanUtils.copyProperties(controllerBean,queryController);
                queryController.setId(id);
                controllerService.updateById(queryController);
            }

            //处理接口
            List<DocInterfaceBean> interfaces = api.getInterfaces();
            if(interfaces==null || interfaces.isEmpty()){
                continue;
            }
            // 存放interface列表的文件内容
            DBModuleInterfaceEntity queryInterface = new DBModuleInterfaceEntity();
            queryInterface.setProjectId(ProjectContext.currentProjectId);
            queryInterface.setControllerId(queryController.getId());
            List<DBModuleInterfaceEntity> apiInterfaceBeans = interfaceService.list(Wrappers.lambdaQuery(queryInterface));
            if (apiInterfaceBeans == null) {
                apiInterfaceBeans = new ArrayList<>();
            }
            //数据库里已存在的当前controller下的接口集合
            Map<String,DBModuleInterfaceEntity> allExistInterface = apiInterfaceBeans.stream().collect(Collectors.toMap(DBModuleInterfaceEntity::getInterfaceUnique, Function.identity()));
            for (DocInterfaceBean itf : interfaces) {
                //接口详情
                DBModuleInterfaceEntity interfaceBean = itf.getInterfaceBean();
                //接口参数相关
                DBInterfaceParamEntity requestParam = itf.getRequestParam();
                //如果数据库中已存在该接口，则不进行处理
                DBModuleInterfaceEntity dbFindInterface = allExistInterface.get(interfaceBean.getInterfaceUnique());
                if(dbFindInterface!=null && !dbFindInterface.getShowType().equals(interfaceBean.getShowType())){
                    dbFindInterface.setShowType(interfaceBean.getShowType());
                    interfaceService.updateById(dbFindInterface);
                }
                if(dbFindInterface!=null && dbFindInterface.getUpgradeStatus()==0){
                    continue;
                }
                interfaceBean.setControllerId(queryController.getId());
                interfaceBean.setProjectId(queryController.getProjectId());
                if(interfaceBean.getUpgradeStatus() == null){
                    interfaceBean.setUpgradeStatus(0);
                }
                if(dbFindInterface != null){
                    interfaceBean.setId(dbFindInterface.getId());
                    interfaceBean.setUpgradeStatus(0);
                    if(interfaceBean.getRenewType().equals(RenewType.skip.getType())){
                        continue;
                    }
                    if(interfaceBean.getRenewType().equals(RenewType.increment.getType())){
                        interfaceBean.mergin(dbFindInterface);
                    }
                    if(StringUtil.isEmpty(dbFindInterface.getOrigin())){
                        interfaceBean.createOrigin();
                    }else{
                        interfaceBean.setOrigin(dbFindInterface.getOrigin());
                    }
                    interfaceService.updateById(interfaceBean);
                }else{
                    interfaceService.save(interfaceBean);
                }
                allExistInterface.put(interfaceBean.getInterfaceUnique(),interfaceBean);
                //处理接口参数
                DBInterfaceParamEntity old = interfaceParamService.getOne(Wrappers.lambdaQuery(DBInterfaceParamEntity.class)
                        .eq(DBInterfaceParamEntity::getInterfaceId, interfaceBean.getId())
                ,false);
                requestParam.setInterfaceId(interfaceBean.getId());
                requestParam.setProjectId(interfaceBean.getProjectId());
                if(old == null){
                    //之前不存在接口参数，直接添加到库
                    interfaceParamService.save(requestParam);
                    continue;
                }
                //处理已经存在的参数
                if(!StringUtil.isEmpty(requestParam.getRequestParamJson())){
                    if(!StringUtil.isEmpty(old.getRequestParamJson())){
                        List<DocParamEntity> oldParams = JsonUtil.jsonToList(old.getRequestParamJson(), DocParamEntity.class);
                        List<DocParamEntity> nowParams = JsonUtil.jsonToList(requestParam.getRequestParamJson(), DocParamEntity.class);
                        paramsMergin(nowParams,oldParams.stream().collect(Collectors.toMap(DocParamEntity::getUnique,Function.identity())));
                        requestParam.setRequestParamJson(JsonUtil.beanToJson(nowParams));
                    }
                }
                if(!StringUtil.isEmpty(requestParam.getResponseParamJson())){
                    if(!StringUtil.isEmpty(old.getResponseParamJson())){
                        List<DocParamEntity> oldParams = JsonUtil.jsonToList(old.getResponseParamJson(), DocParamEntity.class);
                        List<DocParamEntity> nowParams = JsonUtil.jsonToList(requestParam.getResponseParamJson(), DocParamEntity.class);
                        paramsMergin(nowParams,oldParams.stream().collect(Collectors.toMap(DocParamEntity::getUnique,Function.identity())));
                        requestParam.setResponseParamJson(JsonUtil.beanToJson(nowParams));
                    }
                }
                requestParam.setId(old.getId());
                interfaceParamService.updateById(requestParam);
            }
        }
    }

    private void paramsMergin(List<DocParamEntity> now,Map<String,DocParamEntity> old){
        if(now==null || now.isEmpty()){
            return ;
        }
        for (DocParamEntity nowParam : now) {
            DocParamEntity oldParam = old.get(nowParam.getUnique());
            if(oldParam!=null && !StringUtil.isEmpty(oldParam.getOrigin())){
                DocParamEntity origin = JsonUtil.jsonToBean(oldParam.getOrigin(),DocParamEntity.class);
                paramsMergin(nowParam,oldParam,origin);
                nowParam.setOrigin(JsonUtil.beanToJson(origin));
            }
            if(nowParam.getChildren()!=null && !nowParam.getChildren().isEmpty()){
                paramsMergin(nowParam.getChildren(),old);
            }
        }
    }

    private void paramsMergin(DocParamEntity now,DocParamEntity old,DocParamEntity origin){
        if(now.getRenewType().equals(RenewType.skip.getType())){
            BeanUtils.copyProperties(old,now);
            return ;
        }
        if(now.getRenewType().equals(RenewType.overwrite.getType())){
            return ;
        }
        EasyapiOriginUtil.mergin(now,old,origin);
    }

    public DocClassBean createControllerApi(Class aClass){
        String canonicalName = aClass.getCanonicalName();
        //获取controller源文件路径
        File controllerFile = null;
        for (String path : ProjectContext.projectBasePath) {
            String controllerPath = path + File.separator
                    + aClass.getCanonicalName().replace(".", File.separator) + ".java";
            controllerFile = new File(controllerPath);
            if(controllerFile.exists()){
                break;
            }
        }
        //读取controller源文件
        JavaSourceReader controllerSourceReader = new JavaSourceReader();
        if(controllerFile!=null && controllerFile.exists()){
            controllerSourceReader = JavaSourceReader.builder(controllerFile);
        }
        //组装基础参考信息，包过当前类、方法、类注释、方法注释等等
        ApiExtra extra = new ApiExtra();
        extra.setControllerClass(aClass);
        extra.setControllerComment(controllerSourceReader.getComment());
        //如果设置了扫描包并且当前类不属于该包，则忽略该类
        if (!StringUtil.isEmpty(all.getConfiguration().getScanPackage()) && !canonicalName.startsWith(all.getConfiguration().getScanPackage())) {
            return DocClassBean.EMPTY;
        }
        //如果设置了忽略则跳过
        ReadControllerOperator controllerOperator = ProjectContext.controllerOperator;
        if (controllerOperator.ignore(aClass,extra)) {
            return DocClassBean.EMPTY;
        }
        //方法最终返回
        DocClassBean result = new DocClassBean();

        //构建controller
        DBModuleControllerEntity controllerBean = ControllerCreator.builder(aClass)
                .setFilter(controllerOperator)
                .setExtra(extra)
                .buildController();
        controllerBean.setProjectId(ProjectContext.currentProjectId);
        controllerBean.setModuleId(ProjectContext.currentModuleId);

        result.setController(controllerBean);
        extra.setDbController(controllerBean);
        extra.setStep(ApiCreateStep.Controller);

        ReadInterfaceOperator interfaceOperator = ProjectContext.interfaceOperator;
        //获取全部接口方法
        List<Method> methods = interfaceOperator.readAllInterfaces(aClass,extra);

        //==================以下采取新的读法
        List<MethodComment> methodComment = controllerSourceReader.getComment().getMethods();
        Map<String, Map<String, String>> readMethodParamComment = new HashMap<>();
        for (MethodComment comment : methodComment) {
            List<SourceParameterComment> parameters = comment.getParameters();
            Map<String, String> map = new HashMap<>();
            for (SourceParameterComment parameter : parameters) {
                map.put(parameter.getName(), parameter.getComment());
            }
            readMethodParamComment.put(comment.getName(), map);
        }
        //==================

        for (Method method : methods) {
            //如果接口设置忽略则跳过
            if (interfaceOperator.ignore(method,extra)) {
                continue;
            }

            MethodComment methodSourceComment = controllerSourceReader.getComment().getMethod(method.getName());
            extra.setMethod(method);
            extra.setMethodComment(methodSourceComment);
            extra.setStep(ApiCreateStep.Interface);
            //构建接口
            DBModuleInterfaceEntity interfaceBean = InterfaceCreator.builder(method)
                    .setFilter(interfaceOperator)
                    .setApiExtra(extra)
                    .buildInterface();
            interfaceBean.setProjectId(controllerBean.getProjectId());
            interfaceBean.setModuleId(controllerBean.getModuleId());
            interfaceBean.setControllerClass(controllerBean.getClassName());
            interfaceBean.setControllerId(controllerBean.getId());
            extra.setDbInterface(interfaceBean);
            List<String> customSearch = interfaceOperator.customSearch(method, extra);
            interfaceBean.setCustomTags(customSearch==null?"":String.join(",",customSearch));
            if(!StringUtil.isEmpty(interfaceBean.getCustomTags()) && interfaceBean.getCustomTags().length()>150){
                interfaceBean.setCustomTags(interfaceBean.getCustomTags().substring(0,150));
            }
            interfaceBean.setSearchTags(DBModuleInterfaceEntity.buildSearchTag(interfaceBean));
            DocInterfaceBean docInterfaceBean = new DocInterfaceBean();
            docInterfaceBean.setInterfaceBean(interfaceBean);

            //构建方法的请求、响应及mock参数
            ReadBeanOperator beanOperator = ProjectContext.beanOperator;
            ReadMockTemplateOperator mockOperator = ProjectContext.mockTemplateOperator;
            MethodParamsCreator methodParamsCreator = MethodParamsCreator.build(aClass, method)
                    .withBeanCreator(JavaBeanCreator.builder(beanOperator,ProjectContext.projectBasePath,mockOperator,extra))
                    .withMockFilter(mockOperator)
                    .withReqFilter(ProjectContext.requestOperator)
                    .withResFilter(ProjectContext.responseOperator)
                    .withBeanFilter(beanOperator)
                    .withExtra(extra)
                    .create();

            //将参数存储数据库
            String requestParams = JsonUtil.beanToJson(methodParamsCreator.getRequestParameters());
            DBInterfaceParamEntity reqPram = new DBInterfaceParamEntity();
            reqPram.setProjectId(ProjectContext.currentProjectId);
            reqPram.setProjectId(ProjectContext.currentProjectId);
            reqPram.setInterfaceId(interfaceBean.getId());
            reqPram.setCreateTime(System.currentTimeMillis());
            reqPram.setUpdateTime(System.currentTimeMillis());
            reqPram.setRequestParamJson(requestParams);
            reqPram.setResponseParamJson(JsonUtil.beanToJson(methodParamsCreator.getReturnParameter()));
            reqPram.setResponseMock(methodParamsCreator.getResponseMock());
            reqPram.setRequestMock(methodParamsCreator.getRequestMock());
            docInterfaceBean.setRequestParam(reqPram);
            result.getInterfaces().add(docInterfaceBean);
        }
        return result;
    }
}
